Url: https://github.com/rnovacek/konkretcmpi
Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
Name:           konkretcmpi
Version:        0.9.2
Release:        alt2_12
Summary:        Tool for rapid CMPI providers development

License:        MIT
Source0:        https://github.com/rnovacek/%{name}/archive/%{version}/%{name}-%{version}.tar.gz

BuildRequires:  sblim-cmpi-devel
BuildRequires: ctest cmake
BuildRequires:  python-devel
BuildRequires:  swig

Patch0:         konkretcmpi-0.9.2-fix-returning-instance-from-method.patch
Patch1:         konkretcmpi-0.9.2-honor-string-properties-with-EmbeddedInstance.patch
Patch2:         konkretcmpi-0.9.2-fix-segfault-mofelement.patch
Source44: import.info

%description
KonkretCMPI makes CMPI provider development easier by generating type-safe 
concrete CIM interfaces from MOF definitions and by providing default 
implementations for many of the provider operations.

%package devel
Group: Other
Summary:        Development files for konkretcmpi package
Requires:       %{name}%{?_isa} = %{version}

%description devel
This package provides required files for development using konkretcmpi.

%package -n python-module-konkretcmpi
Group: Other
Summary:        Python bindings for konkretcmpi
Requires:       %{name}%{?_isa} = %{version}
Requires:       python

%description -n python-module-konkretcmpi
This package contains python binding for konkretcmpi.


%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1


%build
mkdir -p %{_target_platform}
pushd %{_target_platform}
CXXFLAGS="%optflags -fno-delete-null-pointer-checks"
export CXXFLAGS
%{fedora_cmake} -DWITH_PYTHON=ON ..
popd

make %{?_smp_mflags} -C %{_target_platform}


%install
make install/fast DESTDIR=$RPM_BUILD_ROOT -C %{_target_platform}

# Don't package .la object
rm -rf $RPM_BUILD_ROOT/usr/lib*/libkonkret.la

%files
%doc README COPYING
%{_bindir}/konkret
%{_bindir}/konkretreg
%{_libdir}/libkonkret.so.0*
%{_libdir}/libkonkretmof.so.0*

%files devel
%exclude %{_datadir}/cmake/Modules/FindCMPI.cmake
%exclude %{_datadir}/cmake/Modules/FindKonkretCMPI.cmake
%{_includedir}/konkret/konkret.h
%{_libdir}/libkonkret.so
%{_libdir}/libkonkretmof.so

%files -n python-module-konkretcmpi
%{python_sitelibdir}/konkretmof.py*
%{python_sitelibdir}/_konkretmof.so


%changelog
