# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           kroniax
Version:        1.2
Release:        alt2_10
Summary:        Sidescrolling skill-based game
Group:          Games/Arcade
License:        MIT
URL:            http://www.indiedb.com/games/kroniax
# Git repo: https://github.com/AlexAUT/Kroniax
Source0:        %{name}-%{version}.tar.xz
Patch0:         kroniax-1.2-mga-datadir.patch
Patch1:         kroniax-1.2-fix-missing-include-cmath.patch

BuildRequires:  cmake
BuildRequires:  pkgconfig(sfml-all)
Source44: import.info

%description
Kroniax is a sidescroller skill-based game. The main goal is to steer
a ship through each level without touching the walls. Players have to
steer their ship up by pressing the spacebar to counteract gravity.

A map editor is included to create custom maps.

%prep
%setup -q
%patch0 -p1
%patch1 -p1


# workaround FTBFS with SFML >= 2.5
sed -i -e 's,${SFML_LIBRARIES},sfml-audio sfml-graphics sfml-window sfml-system sfml-network,' CMakeLists.txt

%build
%{mageia_cmake}
%mageia_cmake_build

%install
install -D -m755 build/Kroniax %{buildroot}%{_gamesbindir}/%{name}

install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a data/* %{buildroot}%{_gamesdatadir}/%{name}

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Kroniax
Comment=Sidescrolling skill-based game
GenericName=Skill game
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Game;ActionGame;
EOF

install -D -m644 data/images/icon.png \
    %{buildroot}%{_datadir}/icons/hicolor/64x64/apps/%{name}.png

%files
%doc README.md
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/64x64/apps/%{name}.png


%changelog
