# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           kytea
Version:        0.4.7
Release:        alt1_3
Summary:        Toolkit for analyzing texts in Japanese, Chinese, and other languages
Source0:        https://www.phontron.com/kytea/download/%{name}-%{version}.tar.gz
URL:            https://www.phontron.com/kytea/

Group:          Text tools
License:        ASL 2.0
BuildRequires:  libstdc++-devel
Source44: import.info

%description
General toolkit for analyzing text, with a focus on Japanese, Chinese
and other languages requiring word or morpheme segmentation.

KyTea is able to perform the following types of processing:
- Word Segmentation: it can separate an unsegmented text stream into
appropriate units (words or morphemes).
- Tagging: it can estimate the tags for words such as POS (part of
speech) tags.
- Pronunciation: it has the ability to estimate the pronunciation
of unknown words.

While KyTea comes with a default model, if you have your own annotated
text, it provides a tool to train your own model.

%prep
%setup -q

%build
# fix build on aarch64
autoreconf -vfi

%configure --disable-static
%make_build

%install
%makeinstall_std

%files
%{_bindir}/kytea
%{_bindir}/train-kytea
%{_libdir}/libkytea.so*
%{_datadir}/kytea/model.bin

%exclude %{_libdir}/pkgconfig/*
%exclude %{_includedir}/kytea
%exclude %{_bindir}/api-example


%changelog
