Group: Sound
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ladspa-cmt-plugins
Version:        1.16
Release:        alt2_34
Summary:        A collection of LADSPA plugins
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License:        GPL-2.0-or-later
URL:            http://www.ladspa.org/
Source0:        http://www.ladspa.org/download/cmt_src_%{version}.tgz
Source1:        cmt.rdf
Patch1:         cmt-1.15-addnoise.patch
Patch2:         cmt-1.15-dontdenormal.patch
Patch3:         cmt-1.15-nostrip.patch
BuildRequires:  gcc-c++
BuildRequires:  ladspa_sdk
Requires:       ladspa_sdk
Obsoletes:      cmt <= 1.15-4
Provides:       cmt = %{version}-%{release}
Source44: import.info

%description
The Computer Music Toolkit (CMT) is a collection of LADSPA plugins for
use with software synthesis and recording packages on Linux. See the
license before use.

The CMT is developed primarily by Richard W.E. Furse the principle
designer of the LADSPA standard, with additional plugins by Jezar and
David Bartold. If you are a programmer or can write documentation and
would like to help out, please feel free to contact Richard.


%prep
%setup -q -n cmt
%patch1  -p1
%patch2  -p1
%patch3  -p1
chmod -x doc/plugins.html src/freeverb/Components/tuning.h
# Enforce Fedora link flags
sed -i "s|-shared|-shared $RPM_LD_FLAGS|" src/makefile
mv doc/COPYING .

%build
make -C src %{?_smp_mflags} CFLAGS="$RPM_OPT_FLAGS -fPIC" 


%install
mkdir -p %{buildroot}%{_libdir}/ladspa
mkdir -p %{buildroot}%{_datadir}/ladspa/rdf
make -C src INSTALL_PLUGINS_DIR="%{buildroot}%{_libdir}/ladspa/" \
                 install
install -p -m 0644 %{SOURCE1} %{buildroot}%{_datadir}/ladspa/rdf



%files
%doc README doc/*
%doc --no-dereference COPYING
%{_libdir}/ladspa/*.so
%{_datadir}/ladspa/rdf/*


%changelog
