# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 0.9.1
%define        plugindir    %{_libdir}/ladspa
%define        srcname      ladspa-bs2b-%{version}

Name:          ladspa-plugins-bs2b
Version:       0.9.1
Release:       alt1_7
Summary:       Bauer stereo to binaural audio plugins for LADSPA
License:       GPLv2
Group:         Sound

URL:           https://bs2b.sourceforge.net/
Source0:       %{srcname}.tar.bz2

BuildRequires: ladspa_sdk
BuildRequires: pkgconfig(libbs2b)

Requires:      ladspa_sdk
Provides:      ladspa-bs2b = %{version}-%{release}
Source44: import.info

%description
The Bauer stereophonic-to-binaural DSP (bs2b) is designed to improve
headphone listening of stereo audio records. Typical stereo recordings
are made for listening with speakers. What's missing in headphones is
the sound going from each channel to the opposite ear, arriving a
short time later for the extra distance traveled, and with a bit of
high frequency roll-off for the shadowing effect of the head. The time
delay to the far ear should also be somewhat longer at low frequencies
than at high frequencies. bs2b implements both of these ideas to
transform stereophonic recordings for headphone listening. This plugin
allows the bs2b library to be used with the LADSPA plug-in
architecture.

%prep
%setup -q -n %{srcname}

# make autoreconf happy
sed -i -e 's, dist-lzma,,' configure.ac

%build
# fix build on aarch64
autoreconf -vfi

%configure --disable-static
%make_build

%install
%makeinstall_std

find %{buildroot}%{_libdir} -name *.la -delete

%files
%doc AUTHORS THANKS
%dir %{plugindir}
%{plugindir}/*.so




%changelog
