Group: Graphics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
%define fedora 37
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           laughlin-backgrounds
Version:        14.1.0
Release:        alt1_26
Summary:        Laughlin desktop backgrounds

License:        CC-BY-SA
URL:            https://fedoraproject.org/wiki/F14_Artwork
Source0:        https://fedorahosted.org/released/design-team/%{name}-%{version}.tar.lzma

BuildArch:      noarch

# for %%_kde4_* macros
Requires:       %{name}-gnome = %{version}-%{release}
Requires:       %{name}-kde = %{version}-%{release}
Source44: import.info


%description
This package contains desktop backgrounds for the Laughlin theme. Pulls in both
Gnome and KDE themes.

%package        single
Group: Graphics
Summary:        Single screen images for Laughlin Backgrounds
License:        CC-BY-SA

%description    single
This package contains single screen images for Laughlin Backgrounds

%package        animated
Group: Graphics
Summary:        Images for Time of Day animation for Laughlin Backgrounds
License:        CC-BY-SA
Requires:       %{name}-single = %{version}-%{release}

%description    animated
This package contains single screen images for Time of Day animation for 
Laughlin Backgrounds

%package        animated-gnome
Group: Graphics
Summary:        Time of Day animation for Laughlin Backgrounds for Gnome
License:        CC-BY-SA
Requires:       %{name}-animated = %{version}-%{release}

%description    animated-gnome
This package contains Time of Day animated wallpaper for Gnome dekstop for
the Laughlin theme.

%package        kde 
Group: Graphics
Summary:        Laughlin Wallpapers for KDE 
%if 0%{?fedora} == 14
Provides:       system-backgrounds-kde = %{version}-%{release}
%endif

Requires:       %{name}-single = %{version}-%{release} 

%description    kde 
This package contains KDE desktop wallpapers for the Laughlin theme.

%package        gnome 
Group: Graphics
Summary:        Laughlin Wallpapers for Gnome 

Requires:       %{name}-single = %{version}-%{release} 
%if 0%{?fedora} == 14
Provides:        system-backgrounds-gnome = %{version}-%{release}
%endif

%description    gnome 
This package contains Gnome desktop wallpapers for the Laughlin theme.

%package        extras-single
Group: Graphics
Summary:        Single screen images for Laughlin Extras Backrounds
License:        CC-BY and CC-BY-SA

%description    extras-single
This package contains single screen images for Laughlin supplemental wallpapers

%package        extras-gnome
Group: Graphics
Summary:        Extra Laughlin Wallpapers for Gnome

Requires:       %{name}-extras-single

%description    extras-gnome
This package contains Laughlin supplemental wallpapers for Gnome

%package        extras-kde
Group: Graphics
Summary:        Extra Laughlin Wallpapers for KDE

Requires:       %{name}-extras-single

%description    extras-kde
This package contains Laughlin supplemental wallpapers for Gnome


%prep
%setup -q


%build
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT


%files
#doc %_docdir/%name

%files single
%doc CC-BY-SA?3.0 Attribution
#There'll be also dual wallpapers in dual subpackage in the future, hence the 
# %%dir ownership is treated separately
%dir %{_datadir}/backgrounds/laughlin
%dir %{_datadir}/backgrounds/laughlin/default
%{_datadir}/backgrounds/laughlin/default/normalish
%{_datadir}/backgrounds/laughlin/default/standard
%{_datadir}/backgrounds/laughlin/default/wide

%files animated
%dir %{_datadir}/backgrounds/laughlin/default-tod
%{_datadir}/backgrounds/laughlin/default-tod/normalish
%{_datadir}/backgrounds/laughlin/default-tod/standard
%{_datadir}/backgrounds/laughlin/default-tod/wide

%files animated-gnome
%{_datadir}/backgrounds/laughlin/default-tod/laughlin.xml
%{_datadir}/gnome-background-properties/desktop-backgrounds-laughlin-animated.xml

%files kde
%{_kde4_datadir}/wallpapers/Laughlin/

%files gnome
%{_datadir}/backgrounds/laughlin/default/laughlin.xml
%{_datadir}/gnome-background-properties/desktop-backgrounds-laughlin.xml

%files extras-single
%doc CC-BY?2.0 CC-BY-SA?2.0 CC-BY-SA?3.0 Attribution
%{_datadir}/backgrounds/laughlin/extras/*.jpg

%files extras-gnome
%{_datadir}/backgrounds/laughlin/extras/laughlin-extras.xml
%{_datadir}/gnome-background-properties/desktop-backgrounds-laughlin-extras.xml

%files extras-kde
%{_kde4_datadir}/wallpapers/Laughlin_*/


%changelog
