Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# NOTE: upstream does not make releases and has no version numbering scheme.
# We check the code out of git and use the date of the last commit as the
# version number.
%global gittag   15f53d6feb84e4ddb41deaf2b5630f5c1303b06d
%global shorttag %(cut -b -7 <<< %{gittag})

Name:           lfsc
Version:        0.20210305
Release:        alt1_5
Summary:        SMT proof checker

License:        BSD-3-Clause
URL:            https://github.com/cvc5/LFSC
Source0:        https://github.com/cvc5/LFSC/archive/%{gittag}/%{name}-%{shorttag}.tar.gz
# The next few sources contain commonly used proof definitions
Source1:        http://clc.cs.uiowa.edu/lfsc/euf_interpolation.plf
Source2:        http://clc.cs.uiowa.edu/lfsc/sat.plf
Source3:        http://clc.cs.uiowa.edu/lfsc/smt.plf
Source4:        http://clc.cs.uiowa.edu/lfsc/th_base.plf
Source5:        http://clc.cs.uiowa.edu/lfsc/th_real.plf
Source6:        http://clc.cs.uiowa.edu/lfsc/th_lra.plf
Source7:        http://clc.cs.uiowa.edu/lfsc/th_lra-cvc3.plf
Source8:        http://clc.cs.uiowa.edu/lfsc/color_base.plf
Source9:        http://clc.cs.uiowa.edu/lfsc/color_euf.plf
# Use std::unordered_map instead of the deprecated __gnu_cxx::hash_map
Patch0:         %{name}-map.patch
# The cstdint header is no longer included transitively
Patch1:         %{name}-stdint.patch

BuildRequires:  ctest cmake
BuildRequires:  flex
BuildRequires:  gcc-c++
BuildRequires:  libgmp-devel libgmpxx-devel
BuildRequires:  help2man
BuildRequires:  python3
Source44: import.info

%description
This package contains an SMT proof checker.

%package devel
Group: Other
Summary:        Files needed to compile side conditions
Requires:       %{name} = %{version}-%{release}

%description devel
This package contains the files needed to compile a version of %{name} that
can execute a side condition.

%prep
%setup -q -n LFSC-%{gittag}
%patch0
%patch1


# We want to know about use of deprecated interfaces
sed -i '/Wno-deprecated/d' CMakeLists.txt

# Build a shared library instead of a static library, and give it an soname
sed -e 's/STATIC/SHARED/' \
    -e '/^[[:blank:]]*OUTPUT_NAME lfscc/i\  VERSION 0.0.0\n  SOVERSION 0' \
    -e 's/ARCHIVE DESTINATION/LIBRARY DESTINATION/' \
    -e '/^set_target_properties/iTARGET_LINK_LIBRARIES(liblfscc gmp)' \
    -i src/CMakeLists.txt

# Fix the library install path
if [ "%{_lib}" = "lib64" ]; then
  sed -i 's,/lib,/lib64,' src/CMakeLists.txt
fi

# Fix the test script
sed -i 's,%{_bindir}/env python,/usr/bin/python3,' tests/run_test.py

%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

# Install the proof files
mkdir -p %{buildroot}%{_datadir}/%{name}
cp -p %{SOURCE1} %{SOURCE2} %{SOURCE3} %{SOURCE4} %{SOURCE5} %{SOURCE6} \
   %{SOURCE7} %{SOURCE8} %{SOURCE9} %{buildroot}%{_datadir}/%{name}

# Generate a man page
cd %{_vpath_builddir}/src
mkdir -p %{buildroot}%{_mandir}/man1
export LD_LIBRARY_PATH=$PWD
help2man -N --version-string=%{version} ./lfscc > \
  %{buildroot}%{_mandir}/man1/lfscc.1
# Fix line breaks in the man page
sed -i 's/\\fB/.TP\n&/;s/\\fR: /\\fR\n/' %{buildroot}%{_mandir}/man1/lfscc.1

# Help the debuginfo generator
cp -p ../../src/lexer.flex .
cd -

%check
%fedora_v2_ctest

%files
%doc --no-dereference COPYING
%doc AUTHORS README.md
%{_bindir}/lfscc
%{_datadir}/%{name}/
%{_libdir}/liblfscc.so.0*
%{_mandir}/man1/lfscc.1*

%files devel
%{_includedir}/lfscc.h
%{_libdir}/liblfscc.so

%changelog
