Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: libdmalloc-devel pkgconfig(dbus-1)
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           libsynce
Version:        0.15.1
Release:        alt2_17
Summary:        Connection library for Pocket PC devices

License:        MIT
URL:            http://www.synce.org
Source0:        http://download.sf.net/synce/libsynce-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  libdbus-glib-devel
BuildRequires:  libudev-devel
%if 0%{?fedora} < 16
BuildRequires:  hal-devel
%endif

# Provide an upgrade path from the monilithic synce package
Provides:       synce = %{version}-%{release}
Obsoletes:      synce <= 0.9.1-10
Source44: import.info

%description
The purpose of the SynCE project is to provide a means of
communication with a Windows CE device from a computer running Linux,
FreeBSD or a similar operating system.

%package devel
Group: Development/Other
Summary: Development libraries and header files for SynCE
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
This package contains the header files and link libraries for SynCE
application development. SynCE provides support for communication
between a Windows CE device (PDA, smart phone) and a Linux machine.

For more details on the SynCE project, please refer to the project's
homepage at http://www.synce.org

%prep
%setup -q 

%build
%configure \
--disable-static --disable-rpath \
%if 0%{?fedora} >= 16
--disable-hal-support \
%endif
--enable-udev-support

%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT

rm -f $RPM_BUILD_ROOT%{_libdir}/*.la



%files
%doc README TODO ChangeLog
%{_libdir}/libsynce.so.0*
%{_mandir}/man7/synce.*

%files devel
%{_includedir}/*.h
%{_libdir}/lib*.so
%{_mandir}/man3/*
%{_libdir}/pkgconfig/*.pc

%changelog
