# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: boost-devel boost-filesystem-devel gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define         major        16
%define         libname      libyui-mga-gtk%{major}
%define         develname    libyui-mga-gtk-devel

Name:           libyui-mga-gtk
Version:        1.2.0
Release:        alt3_9
Summary:        UI abstraction library - Mageia extension Gtk plugin
License:        LGPLv2+
Group:          System/Libraries
Url:            https://github.com/manatools/libyui-mga-gtk
Source0:        %{name}-%{version}.tar.gz
Patch0:         00-libyui-gtk-dep.patch

BuildRequires:    pkgconfig(libyui)
BuildRequires:    pkgconfig(libyui-gtk)
BuildRequires:    pkgconfig(libyui-mga)
BuildRequires:    pkgconfig(gtk+-3.0)
BuildRequires:    ccmake cmake ctest
BuildRequires:    boost-complete
BuildRequires:    ghostscript
BuildRequires:    graphviz
Source44: import.info

%description
%{summary}.

#-----------------------------------------------------------------------

%package -n %libname
Summary:        %{summary}
Group:          System/Libraries
Requires:       libyui
Provides:       %{name} = %{version}-%{release}
Provides:       %{name} = %{version}-%{release}
Provides:       %{name}%{major} = %{version}-%{release}
Provides:       %{name}%{major} = %{version}-%{release}

%description -n %libname
This package contains the library needed to run programs
dynamically linked with libyui-mga-gtk.

%files -n %libname
%doc COPYING*
%{_libdir}/yui/libyui-mga-gtk.so.%{major}
%{_libdir}/yui/libyui-mga-gtk.so.%{major}.*

#-----------------------------------------------------------------------

%package -n %develname
Summary:        %{summary} header files
Group:          Development/Other
Requires:       %{libname} = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}
Provides:       yui-mga-gtk-devel = %{version}-%{release}

%description -n %develname
This package provides headers files for libyui-mga-gtk development.

%files -n %develname
%{_includedir}/yui/mga/gtk/
%{_libdir}/yui/libyui-mga-gtk.so

#-----------------------------------------------------------------------

%prep
%setup -q
%patch0 -p1


%build
%{mageia_cmake} \
       -DCMAKE_SKIP_INSTALL_RPATH:BOOL=no \
       -DCMAKE_INSTALL_RPATH:PATH=%{_libdir}/yui
%mageia_cmake_build

%install
%mageia_cmake_install


%changelog
