# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Lynx-like text WWW browser
Name:		linkx
Version:	2.2
Release:	alt1_29
License:	GPL
Group:		Networking/WWW
URL:		https://linkx.sourceforge.net/
#Source0:	%%{name}-%%{ver}.tar.bz2
Source0:	%{name}.tar.gz
Patch0:		linkx-libpng15.patch
Patch1:		linkx-fix-png-crash.diff
Patch2:		linkx-openssl11.patch
Patch3:		linkx-autoconf.patch
Patch4:		fix-build-with-gcc-14.patch
Patch5:		linkx-fix-build-with-gcc15.patch
BuildRequires:  pkgconfig(x11)
BuildRequires:	bzip2-devel
BuildRequires:	pkgconfig(openssl)
BuildRequires:	libfreetype-devel
BuildRequires:	pkgconfig(gdlib)
BuildRequires:	gpm-devel
BuildRequires:	pkgconfig(libjpeg)
BuildRequires:	pkgconfig(libpng)
BuildRequires:	pkgconfig(zlib)
BuildRequires:	pkgconfig(libtiff-4)
Provides:	webclient
Source44: import.info

%description
Links is a text based WWW browser, at first look similar to Lynx, but
somehow different:

- renders tables and frames
- displays colors as specified in current HTML page
- uses drop-down menu (like in Midnight Commander)
- can download files in background
- partially handle Javascript

Linkx is based on top of links and offer the below features:
- Cookies (load/save/block)
- Tabs
- Access keys (really, really cool feature)
- Forward!
- XDnD drop support
- Italics (some compile time fiddling required)

%prep
%setup  -q -n %name/%name
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1


%build
autoreconf -fi
%configure --enable-graphics --enable-javascript
%make_build

%install
%makeinstall_std

mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{_vendor}-%{name}.desktop << EOF
[Desktop Entry]
Name=Links (tabbed)
Comment=Lynx-like text WWW browser
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=Network;WebBrowser;
EOF

mkdir -p %{buildroot}%{_datadir}/pixmaps
install -m 0644 links_32x32.xpm %{buildroot}%{_datadir}/pixmaps/%{name}.xpm

#conflicts with links:
mv %buildroot%_bindir/link{s,x}

%files 
%doc AUTHORS BUGS ChangeLog README SITES TODO
%_bindir/%name
%_mandir/*/*
%_datadir/applications/%{_vendor}-%{name}.desktop
%{_datadir}/pixmaps/%{name}.xpm


%changelog
