# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Show a logo with some system info on the console
Name: linux_logo
Version: 6.0
Release: alt1_1
License: GPLv2
Group: System/Base
URL: http://www.deater.net/weave/vmwprod/linux_logo/
Source: http://www.deater.net/weave/vmwprod/linux_logo/linux_logo-%{version}.tar.gz
Patch0: linux_logo-5.11-add-ppc64le.patch
Patch1: linux_logo-5.11-default-logo.patch
Patch2: 0001-initial-aarch64-support.patch
Patch3: linux_logo-5.11-kvm-cpus.patch
BuildRequires: gettext gettext-tools
BuildRequires: which
Source44: import.info

%description
Linux logo shows a logo, a colorful penguin by default, with some optional
system info on the console. It's typically used to generate issue and motd
files or executed upon login.

%prep
%setup -q
#patch0 -p1
#patch1 -p1
#patch2 -p1
#patch3 -p1

%build
# We still need to override CFLAGS later on, configure can't set them
%configure --prefix=%{_prefix}
make logos-all %{?_smp_mflags} CFLAGS="%{optflags}"

%install
make install PREFIX=%{buildroot}%{_prefix}
%find_lang %{name}

%files -f %{name}.lang
%{!?_licensedir:%global license %%doc}
%doc --no-dereference COPYING
%doc CHANGES* LINUX_LOGO.FAQ README* TODO USAGE
%{_bindir}/linux_logo
%{_mandir}/man1/linux_logo.1*

%changelog
