Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global udevdir %(pkg-config --variable=udevdir udev)

Name:           linuxconsoletools
Version:        1.7.1
Release:        alt1_2
Summary:        Tools for connecting joysticks & legacy devices to the kernel's input subsystem
License:        GPLv2+
URL:            http://sourceforge.net/projects/linuxconsole/
Source:         http://downloads.sourceforge.net/linuxconsole/%{name}-%{version}.tar.bz2

BuildRequires:  gcc
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  systemd systemd-boot-efi udev

Provides:       joystick = %{version}-%{release}
Provides:       ff-utils = 1:%{version}-%{release}
Obsoletes:      joystick < 1.2.16-1
Obsoletes:      ff-utils < 2.4.22-1
Conflicts:      gpm gpm-root
Source44: import.info


%description
This package contains utilities for testing and configuring joysticks,
connecting legacy devices to the kernel's input subsystem (providing support
for serial mice, touchscreens etc.), and test the input event layer.


%prep
%setup -q



%build

%{make_build} PREFIX=%{_prefix}

# moving helper scripts from /usr/share/joystick to /usr/libexec/joystick
sed -i "s|%{_datadir}/joystick|%{_libexecdir}/joystick|g" utils/jscal-restore utils/jscal-store


%install
%{makeinstall_std} PREFIX=%{_prefix}

# moving helper scripts from /usr/share/joystick to /usr/libexec/joystick
install -d -m 0755 %{buildroot}%{_libexecdir}/joystick
mv -f %{buildroot}%{_datadir}/joystick/* %{buildroot}%{_libexecdir}/joystick/

# fixing udev dir
#mv -f %{buildroot}/lib %{buildroot}/usr/

# fixing man permissions
chmod -x %{buildroot}%{_mandir}/man1/*


%files
%doc README NEWS
%doc --no-dereference COPYING
%{_bindir}/ffcfstress
%{_bindir}/ffmvforce
%{_bindir}/ffset
%{_bindir}/fftest
%{_bindir}/inputattach
%{_bindir}/jscal
%{_bindir}/jscal-restore
%{_bindir}/jscal-store
%{_bindir}/jstest
%{_bindir}/evdev-joystick

%{_libexecdir}/joystick

/lib/udev/js-set-enum-leds
%{_udevrulesdir}/80-stelladaptor-joystick.rules

%{_mandir}/man1/*


%changelog
