# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ pkgconfig(atkmm-1.6) pkgconfig(glibmm-2.4) pkgconfig(pangomm-1.4)
# END SourceDeps(oneline)
%define fedora 21
Name:           lostirc
Version:        0.4.6
Release:        alt2_19
Summary:        Simple IRC client for X11

Group:          Networking/WWW
License:        GPLv2+
URL:            http://lostirc.sourceforge.net
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Patch0:         lostirc-0.4.6-FTBFS.patch
Patch1:         lostirc-0.4.6-aarch64.patch

BuildRequires:  libgtkmm2-devel
BuildRequires:  gettext
BuildRequires:  desktop-file-utils
Source44: import.info


%description
Lostirc is a simple, yet very useful IRC-client. It has features such as 
tab-autocompletion, multiple server support, automatic joining of 
servers/channels and DCC sending which should cover the needs of most 
people. The client is 100% keyboard-controllable, and uses the gtkmm GUI 
library

%prep
%setup -q
%patch0 -p1 -b .ftbfs
%patch1 -p1 -b .aarch64
sed -i 's|Icon=%{name}.png|Icon=%{name}|g' %{name}.desktop


%build
%configure
make %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot}

desktop-file-install \
    %if (0%{?fedora} && 0%{?fedora} < 19) || (0%{?rhel} && 0%{?rhel} < 7)
    --vendor fedora \
    %else
    --vendor="" \
    %endif
    --delete-original \
    --remove-category=Application \
    --add-category=GTK \
    --add-category=IRCClient \
    --dir %{buildroot}%{_datadir}/applications \
    %{buildroot}/%{_datadir}/applications/%{name}.desktop


%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS COPYING NEWS README
%{_bindir}/%{name}
%{_datadir}/pixmaps/*.png
%{_datadir}/applications/*.desktop
%{_mandir}/man1/*


%changelog
