Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-generic-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# TODO: Package mplrs, the MPI version.

Name:           lrslib
Version:        7.2
Release:        alt1_6
Summary:        Reverse search for vertex enumeration/convex hull problems

%global upver 0%(sed 's/\\.//' <<< %{version})

License:        GPL-2.0-or-later
URL:            http://cgm.cs.mcgill.ca/~avis/C/lrs.html
Source0:        http://cgm.cs.mcgill.ca/~avis/C/%{name}/archive/%{name}-%{upver}.tar.gz
# This patch was sent upstream on 31 May 2011.  It fixes some miscellaneous
# bugs.
Patch0:         %{name}-fixes.patch

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  libgmp-devel libgmpxx-devel
Source44: import.info

%description
%{name} is a self-contained ANSI C implementation as a callable library
of the reverse search algorithm for vertex enumeration/convex hull
problems and comes with a choice of three arithmetic packages.  Input
file formats are compatible with Komei Fukuda's cdd package (cddlib).
All computations are done exactly in either multiple precision or fixed
integer arithmetic.  Output is not stored in memory, so even problems
with very large output sizes can sometimes be solved.

%package devel
Group: Other
Summary:        Header files and libraries for developing with %{name}
Requires:       %{name} = %{version}-%{release}

%description devel
Header files and libraries for developing with %{name}.

%package utils
Group: Other
Summary:        Sample programs that use %{name}
Requires:       %{name} = %{version}-%{release}

%description utils
Sample programs that use %{name}.

%prep
%setup -q -n %{name}-%{upver}
%patch0


# Remove extraneous executable bits
chmod a-x *.{c,h} ine/test/cp4.ine

%build
# The Makefile is too primitive to use.  For one thing, it only builds
# binaries, not libraries.  We do our own thing here.
# Recent changes to the Makefile make it less primitive, but it still does not
# work well for building on a mixture of 32-bit and 64-bit architectures.

# Upstream wants to use 1.0.0 as the soname version number for now.
%global sover 1
%global ver 1.0.0

CFLAGS="%{optflags} -DMA -I. -I%{_includedir}/boost"

# Build the individual objects
gcc $CFLAGS -fPIC -DSAFE -DLRSLONG -c -o lrslong1.o lrslong.c
gcc $CFLAGS -fPIC -DSAFE -DLRSLONG -c -o lrslib1.o lrslib.c
gcc $CFLAGS -fPIC -DGMP -c -o lrslibgmp.o lrslib.c
gcc $CFLAGS -fPIC -DGMP -c -o lrsgmp.o lrsgmp.c
gcc $CFLAGS -fPIC -c -o lrsdriver.o lrsdriver.c
%if 0%{?__isa_bits} == 64
gcc $CFLAGS -fPIC -DSAFE -DLRSLONG -DB128 -c -o lrslong2.o lrslong.c
gcc $CFLAGS -fPIC -DSAFE -DLRSLONG -DB128 -c -o lrslib2.o lrslib.c
%endif

# Build the library
%if 0%{?__isa_bits} == 64
gcc $CFLAGS %{build_ldflags} -fPIC -shared -Wl,-soname,liblrs.so.%{sover} \
  -o liblrs.so.%{ver} lrslong1.o lrslong2.o lrslib1.o lrslib2.o lrslibgmp.o \
  lrsgmp.o lrsdriver.o -lgmp
%else
gcc $CFLAGS %{build_ldflags} -fPIC -shared -Wl,-soname,liblrs.so.%{sover} \
  -o liblrs.so.%{ver} lrslong1.o lrslib1.o lrslibgmp.o lrsgmp.o lrsdriver.o \
  -lgmp
%endif
ln -s liblrs.so.%{ver} liblrs.so.%{sover}
ln -s liblrs.so.%{sover} liblrs.so

# Build the binaries
%if 0%{?__isa_bits} == 64
gcc $CFLAGS -DB128 -DSAFE lrs.c -o lrs %{build_ldflags} -L. -llrs
gcc $CFLAGS -DB128 lrs.c -o lrsn %{build_ldflags} -L. -llrs
%else
gcc $CFLAGS -DB32 -DSAFE lrs.c -o lrs %{build_ldflags} -L. -llrs
gcc $CFLAGS -DB32 lrs.c -o lrsn %{build_ldflags} -L. -llrs
%endif
gcc $CFLAGS -DGMP lrs.c -o lrsgmp %{build_ldflags} -L. -llrs -lgmp
gcc $CFLAGS -DGMP lrsnash.c lrsnashlib.c -o lrsnash %{build_ldflags} -L. -llrs \
  -lgmp
gcc $CFLAGS -DLRSLONG -DSAFE lrsnash.c lrsnashlib.c -o lrsnash1 %{build_ldflags} \
  -L. -llrs
%if 0%{?__isa_bits} == 64
gcc $CFLAGS -DLRSLONG -DSAFE -DB128 lrsnash.c lrsnashlib.c -o lrsnash2 \
    %{build_ldflags} -L. -llrs
%endif
gcc $CFLAGS 2nash.c -o lrs-2nash %{build_ldflags}
gcc $CFLAGS buffer.c -o lrs-buffer %{build_ldflags}
gcc $CFLAGS hvref.c -o lrs-hvref %{build_ldflags}
gcc $CFLAGS -DGMP checkpred.c -o lrs-checkpred %{build_ldflags} -L. -llrs -lgmp
gcc $CFLAGS -DGMP inedel.c -o lrs-inedel %{build_ldflags} -L. -llrs -lgmp
gcc $CFLAGS -DGMP setupnash.c -o lrs-setupnash %{build_ldflags} -L. -llrs
gcc $CFLAGS -DGMP setupnash2.c -o lrs-setupnash2 %{build_ldflags} -L. -llrs
gcc $CFLAGS -DLRSMP -Dcopy=copy_dict_1 -Dlrs_mp_init=lrs_mp_init_1 -Dpmp=pmp_1 \
  -Drattodouble=rattodouble_1 -Dreadrat=readrat_1 rat2float.c -o lrs-rat2float \
  %{build_ldflags} -L. -llrs
gcc $CFLAGS float2rat.c -o lrs-float2rat %{build_ldflags}

%install
# Install the library
mkdir -p %{buildroot}%{_libdir}
cp -a liblrs.so* %{buildroot}%{_libdir}
chmod 0755 %{buildroot}%{_libdir}/lib*.so.%{ver}

# Install the binaries
mkdir -p %{buildroot}%{_bindir}
install -p -m 0755 lrs lrsgmp lrsnash lrsnash1 lrs-* %{buildroot}%{_bindir}
%if 0%{?__isa_bits} == 64
install -p -m 0755 lrsnash2 %{buildroot}%{_bindir}
%endif
ln -s lrs %{buildroot}%{_bindir}/lrsn
ln -s lrs %{buildroot}%{_bindir}/lrsredund
ln -s lrsgmp %{buildroot}%{_bindir}/lrsredundgmp

# Install the header files, but fix up the include directives.
mkdir -p %{buildroot}%{_includedir}/%{name}
sed -r 's|"(lrs.*\.h)"|<lrslib/\1>|' lrslib.h > \
    %{buildroot}%{_includedir}/%{name}/lrslib.h
touch -r lrslib.h %{buildroot}%{_includedir}/%{name}/lrslib.h

sed -e 's|"gmp.h"|<gmp.h>|' lrsgmp.h > \
    %{buildroot}%{_includedir}/%{name}/lrsgmp.h
touch -r lrsgmp.h %{buildroot}%{_includedir}/%{name}/lrsgmp.h

sed -e 's|"lrsrestart.h"|<lrslib/lrsrestart.h>|' lrsdriver.h > \
    %{buildroot}%{_includedir}/%{name}/lrsdriver.h
touch -r lrsdriver.h %{buildroot}%{_includedir}/%{name}/lrsdriver.h

cp -p lrslong.h lrsmp.h lrsnashlib.h lrsrestart.h \
  %{buildroot}%{_includedir}/%{name}

# Install the man pages
mkdir -p %{buildroot}%{_mandir}/man1
mkdir -p %{buildroot}%{_mandir}/man5
cd man/man1
cp -p checkpred.1 %{buildroot}%{_mandir}/man1/lrs-checkpred.1
cp -p {lrs,lrsnash}.1 %{buildroot}%{_mandir}/man1
echo '.so man1/lrs' > %{buildroot}%{_mandir}/man1/lrs-hvref.1
echo '.so man1/lrs' > %{buildroot}%{_mandir}/man1/lrsredund.1
cd ../man5
cp -p *.5 %{buildroot}%{_mandir}/man5
cd ../..

%files
%doc README
%doc --no-dereference COPYING
%{_libdir}/liblrs.so.1
%{_libdir}/liblrs.so.1.*

%files devel
%doc chdemo.c lpdemo.c lpdemo1.c lpdemo2.c nashdemo.c vedemo.c
%{_includedir}/%{name}
%{_libdir}/liblrs.so
%{_mandir}/man5/lrs*

%files utils
%{_bindir}/lrs*
%{_mandir}/man1/lrs*

%changelog
