Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		ltl2ba
Version:	1.3
Release:	alt2_6
Summary:	Fast translation from LTL formulas to Buchi automata

License:	GPLv2+
URL:		http://www.lsv.fr/~gastin/ltl2ba/
Source0:	http://www.lsv.fr/~gastin/ltl2ba//%{name}-%{version}.tar.gz

BuildRequires:	gcc
BuildRequires:	help2man
Source44: import.info

%description
Translate from Linear temporal logic (LTL) formulas to Buchi automata.
LTL is a type of formal logic that extends formal logic with
qualifiers involving time.
A Buchi automaton is the extension of a finite state automaton
to infinite inputs, and are useful for specifying behavior
of non-terminating systems (such as hardware or operating systems).
A Buchi automaton accepts an infinite input sequence if and only if
there exists a run of the automaton which visits at least one of the
final states infinitely often.

The implementation is based on the translation algorithm by Gastin and Oddoux,
presented at the CAV Conference, held in 2001, Paris, France 2001.

%prep
%setup -q


# Fix encoding
iconv -f latin1 -t utf8 README > README.utf8
mv README.utf8 README

%build
%make_build CFLAGS="%{optflags} -DNXT %{build_ldflags}"
help2man -N --version-string=%{version} ./ltl2ba > ltl2ba.1

%check
# Trivial test, primarily to make sure it compiled into something executable:
./ltl2ba -f "true"

%install
# Install the binary
mkdir -p %{buildroot}%{_bindir}
cp -p ltl2ba %{buildroot}%{_bindir}

# Install the man page
mkdir -p %{buildroot}%{_mandir}/man1
cp -p ltl2ba.1 %{buildroot}%{_mandir}/man1

%files
%doc README
%doc --no-dereference LICENSE
%{_bindir}/ltl2ba
%{_mandir}/man1/ltl2ba.1*

%changelog
