Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           lv2-EQ10Q-plugins
Version:        2.2
Release:        alt1_5
Summary:        LV2 Plugin: Parametric audio equalizer with 12 different filter types

# The vuwidget class is under GPLv3+.  The rest is under GPLv2+.  The GPLv3+ is
# only only included in the parameq_gui.so library.  The other library,
# paramEQ.so, contains only GPLv2+ code.
License:        GPLv2+ and GPLv3+
URL:            http://eq10q.sourceforge.net/
Source0:        http://downloads.sourceforge.net/project/eq10q/eq10q-%{version}.tar.gz
# customuzible paths and flags, upstreamable.
Patch0:         lv2-EQ10Q-plugins-path-and-flags.patch
# use exp10 instead of pow10 (newer glibc), upstreamable.
Patch1:         lv2-EQ10Q-plugins-exp10.patch

BuildRequires:  ctest cmake
BuildRequires:  gcc-c++
BuildRequires:  libfftw3-devel
BuildRequires:  libgtkmm2-devel
BuildRequires:  libplotmm-devel
BuildRequires:  lv2-c++-tools-static
BuildRequires:  pstreams-devel
BuildRequires:  lv2-devel
Requires:  lv2
Source44: import.info

%description
EQ10Q is an audio plug-in using the LV2 standard implementing a powerful and
flexible parametric equalizer.
The goal is to create an equalizer plug-in that includes parametric equalization
with different filter types like peaking, HPF, LPF, Shelving and Notch with IIR
algorithms and a nice GUI displaying the equalization curve.
At the moment we have implemented second order biquadratic filters (Peaking,
Low Shelving, High Shelving and Notch), and configurable order (1, 2, 3, 4) HPF
and LPF filters. All with IIR algorithms.

%prep
%setup -q -n eq10q-%{version}
%patch0 -p1
%patch1 -p1

# Get rid of warnings about spurious exec permissions in debuginfo package
chmod -x gui/widgets/templatewidget.cpp gui/widgets/templatewidget.h *.c *.h */*.c */*.h

# Disable SSE on unsupported architectures
%ifnarch %ix86 x86_64
sed -i 's|-msse -mfpmath=sse||g' CMakeLists.txt
%endif

%build
mkdir -p %{_target_platform}
pushd %{_target_platform}
    %{fedora_cmake} -DCMAKE_INSTALL_PREFIX="%{_libdir}/lv2" ..
%make_build
popd

%install
make install DESTDIR=%{buildroot} -C %{_target_platform}

%files
%doc README
%{_libdir}/lv2/*

%changelog
