%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Support library for writing LV2 plugins in C++
Name:		lv2-c++-tools
Version:	1.0.5
Release:	alt2_25
# Automatically converted from old format: GPLv3+ - review is highly recommended.
License:	GPL-3.0-or-later
URL:		http://ll-plugins.nongnu.org/hacking.html
Source0:	http://download.savannah.nongnu.org/releases/ll-plugins/%{name}-%{version}.tar.bz2

BuildRequires:	boost-complete
BuildRequires:	doxygen
BuildRequires:	gcc-c++
BuildRequires:	libgtkmm2-devel
BuildRequires:	lv2-devel
Source44: import.info


%description
This software package contains libraries and programs that should make it
easier to write LV2 plugins in C++.


%package devel
Group: Development/Other
Summary:	Development files for %{name}
Provides:	%{name}-static = %{version}-%{release}
Requires:	%{name} = %{version}-%{release}
Requires:	pkgconfig

%description devel
This package contains libraries and header files for developing LV2 plugins
that use %{name}.

%prep
%setup -q

# We will use our lv2core
rm -f headers/lv2.h
sed -i -e '/lv2\.h/d' Makefile

%build
# this doesn't use GNU configure
./configure --prefix=%{_prefix} \
	--lv2peg_LDFLAGS="-lboost_system" \
	--CFLAGS="%{optflags}" \
	--LDFLAGS="$RPM_LD_FLAGS"
%make_build

# Build the devel doc
doxygen

%install
make libdir=%{_libdir} DESTDIR=%{buildroot} install

# We don't want this static library. The other ones are needed though
rm -f %{buildroot}%{_libdir}/libpaq.a

# We will put the AUTHORS COPYING ChangeLog README files
# into the proper location
rm -f %{buildroot}%{_docdir}/%{name}/*

# Add missing symlink
ln -sf libpaq.so.0.0.0 %{buildroot}%{_libdir}/libpaq.so.0


%files
%doc AUTHORS ChangeLog README
%doc --no-dereference COPYING
%{_libdir}/lib*.so.*

%files devel
%doc html/*
%{_bindir}/*
%{_includedir}/%{name}/
%{_libdir}/lib*.so
%{_libdir}/lib*.a
%{_libdir}/pkgconfig/*.pc


%changelog
