# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global pkgname ll-plugins

Summary:	Collection of LV2 plugins
Name:		lv2-ll-plugins
Version:	0.2.8
Release:	alt2_24
License:	GPLv3+
Group:		Sound
URL:		http://ll-plugins.nongnu.org/
Source:		http://download.savannah.nongnu.org/releases/ll-plugins/%{pkgname}-%{version}.tar.bz2
# Patch sent to the author via email as there is no upstream tracker
# Fix 64 bit path
Patch0:		ll-plugins-lib64.patch

BuildRequires:	gcc-c++
BuildRequires:	libgtkmm2-devel
BuildRequires:	liblash-devel
BuildRequires:	libsamplerate-devel
BuildRequires:	libsndfile-devel
BuildRequires:	lv2-c++-tools-static
BuildRequires:	lv2-devel

Requires:	lv2
Source44: import.info

%description
lv2-ll-plugins is a small collection of LV2 plugins, including an arpeggiator,
a MIDI keyboard, a drum-machine, a peak meter; and a host that runs them.

%prep
%setup -q -n %{pkgname}-%{version}
%patch0 -p1 -b .lib64

# Don't build and package elven as it is now a separate project
sed -i '/^PROGRAMS = elven/d' Makefile

%build
# this doesn't use GNU configure
./configure --prefix=%{_prefix} --lv2plugindir=%{_libdir}/lv2 --CFLAGS="%{optflags}"
%make_build

%install
make libdir=%{_libdir} DESTDIR=%{buildroot} install

rm -f %{buildroot}%{_docdir}/%{pkgname}/*

%files
%doc AUTHORS ChangeLog README
%doc --no-dereference COPYING
%{_libdir}/lv2/*

%changelog
