# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ waf
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           lv2-triceratops
Version:        0.1.7
Release:        alt2_11
Summary:        An LV2 polyphonic synthesizer

Group:          Sound
# license specified in headers and in plugin manifest (triceratops.ttl) is ISC
# http://opensource.org/licenses/isc
License:        ISC
URL:            http://sourceforge.net/projects/triceratops/
Source0:        http://downloads.sourceforge.net/project/triceratops/triceratops-lv2-v%{version}.tar.gz
BuildRequires:  libjack-devel
BuildRequires:  libsamplerate-devel
BuildRequires:  libsndfile-devel
BuildRequires:  lv2-devel
BuildRequires:  libgtkmm2-devel
BuildRequires:  python
Requires:       lv2
Source44: import.info

%description
Triceratops a polyphonic subtractive synthesizer plugin for use with the LV2 
architecture, there is no standalone version and LV2 is required along 
with a suitable host (e.g. Jalv, Zynjacku, Ardour, Qtractor). 

%prep
%setup -q -n triceratops-lv2-v%{version}
# this is a bug in the installer script - however -finline-functions is necessary here
# https://sourceforge.net/p/triceratops/featurerequests/3/
sed -i -e "s|-lX11'],'-finline-functions'|-lX11','-finline-functions']|" wscript
sed -i -e "s|\['-O3','-std=c++0x'\]|'-std=c++0x %{optflags}'.split(' ')|" wscript

%build
%ifarch sparcv9 sparc64 s390 s390x
export CXXFLAGS="%{optflags} -fPIC"
%else
export CXXFLAGS="%{optflags} -fpic"
%endif

./waf configure -vv --prefix=%{_prefix} \
    --libdir=%{_libdir} --lv2dir=%{_libdir}/lv2
./waf -vv %{?_smp_mflags}

%install
./waf install --destdir=%{buildroot}
rm  -rf %{buildroot}%{_libdir}/lv2/triceratops-presets.lv2/.directory

%files
# do not include COPYING - it is GPLV3 where the project is clearly ISC
# https://sourceforge.net/p/triceratops/featurerequests/4/
%doc README COPYING AUTHORS
%{_libdir}/lv2/triceratops.lv2
%{_libdir}/lv2/triceratops-presets.lv2

%changelog
