Group: System/Base
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		mactel-boot
Version:	0.9
Release:	alt2_32
Summary:	Intel Mac boot files

License:	GPLv2+
URL:		http://www.codon.org.uk/~mjg59/mactel-boot/
Source:		http://www.codon.org.uk/~mjg59/mactel-boot/%{name}-%{version}.tar.bz2
Source1:	mactel-boot-setup
Patch0: mactel-boot-c99.patch

ExclusiveArch:	x86_64

Requires:	coreutils

BuildRequires:  gcc
Source44: import.info
%description
Files for booting Fedora on Intel-based Apple hardware using EFI.

%prep
%setup -q
%patch0 -p1


%build
make PRODUCTVERSION="Fedora %{fedora}" %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT
install -D -m 644 SystemVersion.plist $RPM_BUILD_ROOT/boot/efi/System/Library/CoreServices/SystemVersion.plist
echo "This file is required for booting" >$RPM_BUILD_ROOT/boot/efi/mach_kernel
touch $RPM_BUILD_ROOT/boot/efi/System/Library/CoreServices/boot.efi
touch $RPM_BUILD_ROOT/boot/efi/.VolumeIcon.icns
install -D %{SOURCE1} $RPM_BUILD_ROOT/usr/libexec/mactel-boot-setup
for rpm404_ghost in /boot/efi/System/Library/CoreServices/boot.efi /boot/efi/.VolumeIcon.icns
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%files
%doc --no-dereference GPL
%doc --no-dereference Copyright
/usr/share/man/man1/hfs-bless.1*
/boot/efi/mach_kernel
%dir /boot/efi/System/
%dir /boot/efi/System/Library/
%dir /boot/efi/System/Library/CoreServices/
/boot/efi/System/Library/CoreServices/SystemVersion.plist
/usr/sbin/hfs-bless
/usr/libexec/mactel-boot-setup
%attr(0755, root, root) %ghost /boot/efi/System/Library/CoreServices/boot.efi
%attr(0644, root, root) %ghost /boot/efi/.VolumeIcon.icns

%triggerin -- grub-efi grub2-efi fedora-logos generic-logos
/usr/libexec/mactel-boot-setup

%changelog
