Group: Graphical desktop/GNOME
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/desktop-file-validate python3-module-setuptools
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           mailnag
Version:        2.2.0
Release:        alt1_7
Summary:        Mail notification daemon

License:        GPLv2
URL:            https://github.com/pulb/%{name}
Source0:        https://github.com/pulb/%{name}/archive/v%{version}.tar.gz

# reason for this patch filed in https://github.com/pulb/mailnag/issues/225
Patch0:         mailnag-pingtest_w_fedora.patch

Requires:       python3
Requires:       python3-module-dbus python3-module-dbus-gobject
Requires:       python3-module-pygobject3
Requires:       python3-module-gst1.0
Requires:       python3-module-pyxdg
Requires:       gnome-keyring gnome-keyring-ssh

BuildArch:      noarch
BuildRequires:  python3-devel
BuildRequires:  gettext gettext-tools
BuildRequires:  desktop-file-utils
BuildRequires:  libappstream-glib libappstream-glib-gir
Source44: import.info

%description
Mailnag checks POP3 and IMAP servers for new mail and when it finds one
creates a proper GNOME 3 notification that mentions sender and subject.


%prep
%setup -q -n mailnag-%{version}
%patch0 -b .patch0 -p1

%build
%python3_build

%install
%python3_install
desktop-file-validate $RPM_BUILD_ROOT/%{_datadir}/applications/mailnag.desktop
desktop-file-validate $RPM_BUILD_ROOT/%{_datadir}/applications/mailnag-config.desktop
appstream-util validate-relax --nonet $RPM_BUILD_ROOT/%{_datadir}/metainfo/*.appdata.xml

%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS LICENSE NEWS README.md
%{_bindir}/%{name}*
%{_datadir}/%{name}
%{_datadir}/metainfo/
%{python3_sitelibdir_noarch}/Mailnag
%{python3_sitelibdir_noarch}/%{name}-*-*.egg-info
%{_datadir}/applications/*
%{_datadir}/icons/hicolor/*/apps/%{name}*png

%changelog
