# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/find gcc-c++
# END SourceDeps(oneline)
%define fedora 21
Name:           makehuman
Version:        0.9.1
Release:        alt2_0.11.rc1a
Summary:        Modeling of three-dimensional humanoid characters

Group:          Graphics
License:        GPLv3+
URL:            http://www.dedalo-3d.com
Source0:        http://downloads.sourceforge.net/makehuman/makehuman-%{version}-rc1a.tar.gz
Patch0:         makehuman-0.9.1-gcc43.patch

BuildRequires:  mhgui-devel >= 0.2
BuildRequires:  desktop-file-utils
BuildRequires:  libXmu-devel
BuildRequires:  libXi-devel
Source44: import.info

%description
MakeHuman(C) is an open-source, open graphics library, stand-alone,
multi-platform, software program, which is completely written in 
C++ language. Its purpose is to provide a versatile, professional
and extremely specialized application for parametrical modeling of
three-dimensional humanoid characters.


%prep
%setup -q -n %{name}-%{version}-rc1a
%patch0 -p1 -b .gcc43
chmod 0644 src/*

sed -i.timestamp -e 's|cp --parents|cp -p --parents|g' {data,pixmaps}/Makefile.{am,in}

%build
%configure --disable-static
make %{?_smp_mflags}


%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"

# Removes doc
rm -rf $RPM_BUILD_ROOT%{_prefix}/doc

# Symlink for pixmap
ln -s %{name}/bsimg/characters1/bodybuilder_man01.png $RPM_BUILD_ROOT%{_datadir}/pixmaps/%{name}.png

cat > %{name}.desktop <<EOF
[Desktop Entry]
Encoding=UTF-8
Name=MakeHuman
Comment=Design characters
Comment[fr]=Modéliser des personnages
Exec=makehuman
Terminal=false
Icon=makehuman
Type=Application
Categories=Graphics;
EOF

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install \
%if 0%{?fedora} && 0%{?fedora} < 19
  --vendor fedora                    \
%endif
  --dir ${RPM_BUILD_ROOT}%{_datadir}/applications       \
  %{name}.desktop


%files
%doc AUTHORS COPYING README.txt TODO
%{_bindir}/makehuman
%{_datadir}/%{name}/
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/pixmaps/%{name}/
%{_datadir}/applications/*.desktop


%changelog
