Group: Documentation
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Czech man pages from the Linux Documentation Project
Name: man-pages-cs
Version: 0.18.20090209
Release: alt2_31
# GPLv3 .. coreutils/
# BSD   .. openssh/
License: GPLv2 and GPLv3 and BSD
URL: http://tropikhajma.sweb.cz/man-pages-cs/
Source: http://tropikhajma.sweb.cz/%{name}/%{name}-%{version}.tar.lzma

Patch1:  man-pages-cs-01.patch
Patch2:  man-pages-cs-02.patch
Patch3:  man-pages-cs-03.patch
Patch4:  man-pages-cs-04.patch
Patch5:  man-pages-cs-05.patch
Patch6:  man-pages-cs-06.patch
Patch7:  man-pages-cs-07.patch
Patch8:  man-pages-cs-08.patch
Patch9:  man-pages-cs-09.patch
Patch10: man-pages-cs-10.patch
Patch11: man-pages-cs-11.patch
Patch12: man-pages-cs-0.18.20090209-socket.patch
Patch13: man-pages-cs-0.18.20090209-test.patch

Requires: man-pages-reader
BuildArch: noarch
Source44: import.info

%description
Manual pages from the Linux Documentation Project, translated into
Czech.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

%build
# coreutils directory contains newer version
rm ./procps/kill.1
rm ./procps/uptime.1
rm ./man-pages/man1/du.1
# links to ls - better version in coreutils directory
rm ./man-pages/man1/dir.1
rm ./man-pages/man1/vdir.1

# add deprecation warning to all man pages
warning="\
UPOZORNĚNÍ: Projekt českých manuálových stránek není nadále udržován.\n\
Tato manuálová stránka je zastaralá a informace zde uvedené mohou být\n\
neaktuální.\n\
Aktuální informace naleznete v nápovědě příkazu\n\
nebo anglické verzi manuálových stránek.\n\
"
for sec in 1 2 3 4 5 6 7 8; do
    find . -name "*.$sec" -not -path "*.pc*" -print | xargs sed -i "/^\.SH POPIS$/Ia $warning"
done

%install
mkdir -p $RPM_BUILD_ROOT/%{_mandir}
make install DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir}/cs

%files
%doc CONTRIB README README.Czech Changelog
%{_mandir}/cs/man*/*

%changelog
