# BEGIN SourceDeps(oneline):
BuildRequires: afpfs-ng-devel libgnutls-devel perl(DBI.pm) perl(LWP/UserAgent.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _disable_ld_no_undefined 1

Name:		medusa
Version:	2.2
Release:	alt1_8
Summary:	Medusa Parallel Network Login Auditor
License:	GPLv2
Group:		Networking/Other
URL:		http://www.foofus.net/jmk/medusa/medusa.html
Source0:	http://www.foofus.net/jmk/tools/%{name}-%{version}.tar.gz
Patch0:		349ef7f0c24b627c6dbba8bcd5b47173806473a2.patch
BuildRequires:  libapr1-devel
BuildRequires:  pkgconfig(libssh2)
BuildRequires:  libsubversion-devel
BuildRequires:  postgresql-devel
BuildRequires:  libgcrypt-devel
BuildRequires:  pkgconfig(freerdp2)
BuildRequires:  pkgconfig(openssl)
BuildRequires:  ncpfs-devel
Source44: import.info

%description
Medusa is intended to be a speedy, massively parallel, modular, login
brute-forcer. The goal is to support as many services which allow remote
authentication as possible. The author considers following items as some of the
key features of this application:
* Thread-based parallel testing. Brute-force testing can be performed against
  multiple hosts, users or passwords concurrently.
* Flexible user input. Target information (host/user/password) can be specified
  in a variety of ways. For example, each item can be either a single entry or
  a file containing multiple entries. Additionally, a combination file format
  allows the user to refine their target listing.
* Modular design. Each service module exists as an independent .mod file. This
  means that no modifications are necessary to the core application in order to
  extend the supported list of services for brute-forcing.

%prep
%setup -q
%patch0 -p 1

%build
# fix build on aarch64
autoreconf -vfi
	
# required type off64_t is not available under all environments, ugly hack for ugly system headers
export CPPFLAGS="-Doff64_t=__off64_t %{optflags} -fcommon"
export CFLAGS="-Doff64_t=__off64_t %{optflags} -fcommon"
%configure --enable-module-afp=yes
%make_build

%install
# required type off64_t is not available under all environments, ugly hack for ugly system headers
export CPPFLAGS="-Doff64_t=__off64_t %{optflags}" ; export CFLAGS="-Doff64_t=__off64_t %{optflags}"
%makeinstall_std

%files
%doc AUTHORS ChangeLog NEWS README TODO doc/*.html
%doc --no-dereference COPYING
%{_bindir}/medusa
%{_libdir}/medusa/
%{_mandir}/man1/medusa.1*


%changelog
