Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define Uname MgaRepo

Name: mgarepo
Version: 1.13.2
Release: alt1_35
Summary: Tools for Mageia repository access and management
# tarball needs to be created manually, since tags don't generate releases
# git clone git://git.mageia.org/software/build-system/mgarepo; cd mgarepo; git reset --hard %{version} && make dist
Source:  %{name}-%{version}.tar.xz

# Local fixes to upstream
Patch0500: 0001-Fix-iterating-on-log-entries-with-Python-3.9.patch

# Fedora-specific patches
# Mageia's urpmi is not available in Fedora, so we force DNF for buildrpm command
Patch1000: 0001-buildrpm-Always-use-DNF.patch

# Automatically converted from old format: GPLv2+ - review is highly recommended.
License: GPL-2.0-or-later
URL: http://gitweb.mageia.org/software/build-system/mgarepo/
BuildRequires: python3-devel
BuildRequires: python3-module-pkg_resources python3-module-setuptools
Requires: subversion subversion-server-common
Requires: openssh-clients
Requires: python3-module-rpm
Requires: python3-module-PyGithub >= 1.27.1
Requires: python3-module-httplib2
Requires: wget
BuildArch: noarch
Source44: import.info

%description
Tools for Mageia repository access and management.

It is a fork of repsys :
<http://wiki.mandriva.com/en/Development/Packaging/Tools/repsys>

%package ldap
Group: File tools
Summary: Plugin for retrieving maintainer information from LDAP for mgarepo
Requires: %{name} = %{version}-%{release}
Requires: python3-module-ldap3

%description ldap
A mgarepo plugin that allows retrieving maintainer information shown in
changelogs from a LDAP server.

See mgarepo --help-plugin ldapusers for more information.


%prep
%setup -q
%patch500 -p1
%patch1000 -p1


# Fix requires for RPM Python bindings
sed -e "s/rpm-python/rpm/" -i setup.py

%build
%python3_build

%install
%python3_install

%files
%doc README.BINREPO CHANGES %{name}-example.conf
%attr(0644,-,-) %config(noreplace) %{_sysconfdir}/%{name}.conf
%{_bindir}/%{name}
%{_bindir}/%{name}-ssh
%{_datadir}/%{name}
%{_mandir}/*/*
%{python3_sitelibdir_noarch}/%{Uname}
%exclude %{python3_sitelibdir_noarch}/%{Uname}/plugins/ldapusers.py*
%exclude %{python3_sitelibdir_noarch}/%{Uname}/plugins/__pycache__/__init__*
%exclude %{python3_sitelibdir_noarch}/%{Uname}/plugins/__pycache__/ldapusers*
%{python3_sitelibdir_noarch}/*.egg-info
%{_datadir}/bash-completion/completions/%{name}

%files ldap
%doc README.LDAP
%{python3_sitelibdir_noarch}/%{Uname}/plugins/ldapusers.py*
%{python3_sitelibdir_noarch}/%{Uname}/plugins/__pycache__/__init__*
%{python3_sitelibdir_noarch}/%{Uname}/plugins/__pycache__/ldapusers*


%changelog
