# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
BuildRequires: /proc java-devel-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           micropolisj
Version:        1.6
Release:        alt1_11
Summary:        MicropolisJ - The classic city-building game
Group:          Games/Other
License:        GPLv3+ with exceptions
URL:            https://code.google.com/p/micropolis/
# svn checkout http://micropolis.googlecode.com/svn/tags/micropolis-java/%%{version}
Source0:        %{name}-%{version}.tar.xz
Patch0:         micropolisj-1.6-fix-build-java17.patch
BuildArch:      noarch
BuildRequires:  java-devel-default /proc
BuildRequires:  ant
BuildRequires:  icoutils icoutils-extra
Requires:       java >= 1.7.0
Requires:       javapackages-tools
Provides:       micropolis
Source44: import.info

%description
Micropolis is one of the oldest and greatest city-building games based
on the original code for SimCity.

Enter Micropolis and take control. Be the undisputed ruler of a sophisticated
real-time City Simulation. Become the master of existing cities such as
San Francisco, Tokyo, and Rio de Janeiro, or create your own dream city
(or nightmare slum) from the ground up.

Whether you take over an existing city or build your own, you are the Mayor
and City Planner with complete authority.

This is the Java version of Micropolis, rebranded MicropolisJ.

%prep
%setup -q
%patch0 -p1


%build
%ant

%install
# Install JAR file
install -D -m644 %{name}.jar %{buildroot}%{_javadir}/%{name}.jar

# Wrapper script
cat > %{name}.sh << EOF
#!/bin/sh
java -jar %{_javadir}/%{name}.jar
EOF
install -D -m755 %{name}.sh %{buildroot}%{_gamesbindir}/%{name}

# Icon
for size in 32 64; do
  install -d %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps
  icotool -x -w32 %{name}.ico -o %{buildroot}%{_iconsdir}/hicolor/${size}x${size}/apps/%{name}.png
done

# Menu entry
install -d %{buildroot}%{_datadir}/applications/
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Encoding=UTF-8
Name=MicropolisJ
Comment=The classic city-building game in Java
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Game;Simulation;
EOF

%files
%doc README
%doc --no-dereference COPYING
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/*/apps/%{name}.png
%{_javadir}/%{name}.jar


%changelog
