Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /dev/pts /usr/bin/pathfix.py gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global debug_package %{nil}
%global _hardened_build 1


Name:           micropython
Version:        1.17
Release:        alt1_2
Summary:        Implementation of Python 3 with very low memory footprint

# micorpython itself is MIT
# axtls and berkeley-db are BSD
License:        MIT and BSD

URL:            http://micropython.org/
Source0:        https://github.com/micropython/micropython/archive/v%{version}.tar.gz

%global axtls_commit 531cab9c278c947d268bd4c94ecab9153a961b43
Source1:       https://github.com/micropython/axtls/archive/%{axtls_commit}/axtls-%{axtls_commit}.tar.gz

%global berkley_commit 35aaec4418ad78628a3b935885dd189d41ce779b
Source2:       https://github.com/pfalcon/berkeley-db-1.xx/archive/%{berkley_commit}/berkeley-db-1.xx-%{berkley_commit}.tar.gz

# Other arches need active porting
ExclusiveArch:  %{arm} %{ix86} x86_64

BuildRequires:  gcc
BuildRequires:  python3-devel
BuildRequires:  libffi-devel
BuildRequires:  readline-devel
BuildRequires:  prelink-tools
BuildRequires:  libssl-devel

# Part of the tests runs MicroPython and CPython and compares the results.
# MicroPython is ~3.4, but the testing framework supports newer Pythons as well.
# We use the latest working CPython version in those test, setting the
# MICROPY_CPYTHON3 environment variable.
# Normal %%{pytohn3} is used anywhere else.
# There is no runtime dependency on this CPython (or any other).
%global cpython_version_tests 3.9
BuildRequires:  %{_bindir}/python%{cpython_version_tests}

Provides:       bundled(axtls) = 2.1.5
Provides:       bundled(libdb) = 1.85
Source44: import.info

%description
Implementation of Python 3 with very low memory footprint

%prep
%setup -q -n %{name}-%{version}


# git submodules
rmdir lib/axtls
tar -xf %{SOURCE1}
mv axtls-%{axtls_commit} lib/axtls

head -n 28 lib/axtls/axtlswrap/Makefile > LICENSE.axtls

rmdir lib/berkeley-db-1.xx
tar -xf %{SOURCE2}
mv berkeley-db-1.xx-%{berkley_commit} lib/berkeley-db-1.xx

head -n 32 lib/berkeley-db-1.xx/db/db.c > LICENSE.libdb

# Fix shebangs
files=$(grep -rl '#!/usr/bin/env python')
pathfix.py -i /usr/bin/python3 -p $files

# Removing pre-built binary; not required for build
rm ports/cc3200/bootmgr/relocator/relocator.bin

%build
# Build the cross-compiler
%make_build -C mpy-cross

# Build the unbundled submodules
%make_build -C ports/unix axtls V=1

# Build the interpreter
%make_build -C ports/unix PYTHON=/usr/bin/python3 V=1

execstack -c ports/unix/micropython

%check
pushd ports/unix
export MICROPY_CPYTHON3=python%{cpython_version_tests}
make PYTHON=/usr/bin/python3 V=1 test
popd

%install
mkdir -p %{buildroot}%{_bindir}
install -pm 755 ports/unix/micropython %{buildroot}%{_bindir}

%files
%doc README.md
%doc --no-dereference LICENSE LICENSE.axtls LICENSE.libdb
%{_bindir}/micropython

%changelog
