# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		mihphoto
Version:	1.0.14
Release:	alt1_2
License:	GPLv3
Summary:	Touch-friendly image viewer
Group:		Graphics
Url:		https://github.com/maemo-leste-extras/mihphoto
Source0:	https://github.com/maemo-leste-extras/mihphoto/archive/%{version}/%{name}-%{version}.tar.gz

BuildRequires:	qt5-designer qt5-tools
BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Gui)
BuildRequires:	pkgconfig(Qt5Svg)
BuildRequires:	pkgconfig(Qt5Widgets)
Source44: import.info

%description
MihPhoto is meant to be a simple touchscreen-friendly image viewer.
There a lot of very good image viewers, including many opensource ones,
but most of them are very difficult to handle on a touchscreen.

This application was designed with touchscreens in mind so it is most useful
if you have a touchscreen.

To use the application just open an image; then you can use a swipe gesture
to browse trough all the images located in the same folder as the first one.

%prep
%setup -q


# Fix version
sed -e 's|1.0.13|%{version}|g' -i {%{name}.pro,VERSION}

# Fix .desktop path
sed -e 's|desktopfile.path =.*|desktopfile.path = %{_datadir}/applications|' -i %{name}.pro

# Fix exec command and add MimeType and Categories in desktop file
sed -e 's|Exec=.*|Exec=%{name} %F|' -e '$ a Categories=Graphics;Viewer;' \
    -e '$ a MimeType=image/bmp;image/gif;image/jpeg;image/jpg;image/png;image/tiff;image/x-bmp;image/x-pcx;image/x-tga;image/x-portable-pixmap;image/x-portable-bitmap;image/x-targa;' \
    -i %{name}.desktop

# Set icon files.
sed -e 's|Icon=.*|Icon=%{name}|' -i %{name}.desktop
sed -e "s|hicolor.*|hicolor|;s|icon.files.*|icon.files = \$\$files(hicolor/*)|" -i %{name}.pro
mkdir -p hicolor/{48x48,64x64,128x128,scalable}/apps
cp symbol/icon48.png hicolor/48x48/apps/%{name}.png
cp symbol/icon128.png hicolor/128x128/apps/%{name}.png
cp symbol/MihPhoto.png hicolor/64x64/apps/%{name}.png
cp symbol/icon_main.svg hicolor/scalable/apps/%{name}.svg

%build
%qmake_qt5
%make_build

%install
%makeinstall_std INSTALL_ROOT=%{buildroot}

%files
%doc --no-dereference COPYING
%doc AUTHORS VERSION CREDITS README.md
%{_bindir}/%{name}
%{_datadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/*


%changelog
