Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/clamdscan /usr/bin/clamscan /usr/bin/nm /usr/bin/rspamc /usr/sbin/clamd perl(CGI.pm) perl(CGI/Carp.pm) perl(Crypt/OpenSSL/Random.pm) perl(Date/Format.pm) perl(Date/Parse.pm) perl(Digest/SHA1.pm) perl(File/ReadBackwards.pm) perl(GD/Graph/bars.pm) perl(GD/Graph/linespoints.pm) perl(IO/Socket/SSL.pm) perl(MIME/Lite.pm) perl(MIME/Parser.pm) perl(MIME/Tools.pm) perl(MIME/Words.pm) perl(MLDBM.pm) perl(Net/SMTP.pm) perl(Pod/Usage.pm) perl(Test/Class.pm) perl(Test/Most.pm) perl(Time/Zone.pm)
# END SourceDeps(oneline)
%define _libexecdir %_prefix/libexec
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:        E-Mail filtering framework using Sendmail's Milter interface
Name:           mimedefang
Version:        2.86
Release:        alt2_2
License:        GPLv2+
URL:            https://mimedefang.org/
Source0:        https://mimedefang.org/releases/%{name}-%{version}.tar.gz
Source1:        https://mimedefang.org/releases/%{name}-%{version}.tar.gz.asc
Source2:        gpgkey-9F9B564003DFF9E4D904301E3B6DDB11E78FEBD2.gpg
Source3:        README.FEDORA
Source4:        mimedefang.service
Source5:        mimedefang-multiplexor.service
Source6:        mimedefang-wrapper
Source7:        mimedefang.tmpfilesd
BuildRequires:  gnupg2
BuildRequires:  gcc
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/Embed.pm)
BuildRequires:  %{_sbindir}/sendmail
%if 0%{?fedora} || 0%{?rhel} > 7
BuildRequires:  sendmail-devel >= 8.12.0
BuildRequires:  rpm-macros-systemd
Requires:     perl(Mail/SpamAssassin.pm) >= 1.600
%else
BuildRequires:  sendmail-devel >= 8.12.0
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Requires:       perl(Mail/SpamAssassin.pm) >= 1.600
%endif
%{?systemd_requires}
Requires(pre):  shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Requires(post): perl(Digest/SHA1.pm)
Source44: import.info

%description
MIMEDefang is an e-mail filter program which works with Sendmail 8.12
and later. It filters all e-mail messages sent via SMTP. MIMEDefang
splits multi-part MIME messages into their components and potentially
deletes or modifies the various parts. It then reassembles the parts
back into an e-mail message and sends it on its way.

There are some caveats you should be aware of before using MIMEDefang.
MIMEDefang potentially alters e-mail messages. This breaks a "gentleman's
agreement" that mail transfer agents do not modify message bodies. This
could cause problems, for example, with encrypted or signed messages.

%prep
%setup -q
cp -pf %{SOURCE3} .

%build
%configure --with-milterlib=%{_libdir} --with-user=defang --disable-check-perl-modules --disable-anti-virus
%make_build

%install
%makeinstall_std %{?el7:INSTALL='install -p'} INSTALL_STRIP_FLAG='' install-redhat

# Fix config file, create log directory and remove duplicate
sed -e '1d' -i $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/%{name}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/%{name}
rm -f $RPM_BUILD_ROOT%{_sysconfdir}/mail/sa-mimedefang.cf.example

# Install systemd unit files and tmpfiles
install -D -p -m 644 %{SOURCE4} $RPM_BUILD_ROOT%{_unitdir}/%{name}.service
install -D -p -m 644 %{SOURCE5} $RPM_BUILD_ROOT%{_unitdir}/%{name}-multiplexor.service
install -D -p -m 755 %{SOURCE6} $RPM_BUILD_ROOT%{_libexecdir}/%{name}-wrapper
install -D -p -m 644 %{SOURCE7} $RPM_BUILD_ROOT%{_tmpfilesdir}/%{name}.conf
rm -f $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d/%{name}

# Create a dummy file and install perl script for later executing
touch $RPM_BUILD_ROOT%{_sysconfdir}/mail/mimedefang-ip-key
sed -e '1s@^@#!%{_bindir}/perl\n@' gen-ip-validator.pl > gen-ip-validator.pl.new
install -m 755 gen-ip-validator.pl.new $RPM_BUILD_ROOT%{_bindir}/gen-ip-validator.pl
touch -c -r gen-ip-validator.pl $RPM_BUILD_ROOT%{_bindir}/gen-ip-validator.pl

# Convert everything to UTF-8
iconv -f iso-8859-1 -t utf-8 -o Changelog.utf8 Changelog
touch -c -r Changelog Changelog.utf8
mv -f Changelog.utf8 Changelog
for rpm404_ghost in %{_sysconfdir}/mail/mimedefang-ip-key
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%pre
getent group defang > /dev/null || %{_sbindir}/groupadd -r defang
getent passwd defang > /dev/null || %{_sbindir}/useradd -r -g defang -d %{_localstatedir}/spool/MIMEDefang -s /sbin/nologin -c "MIMEDefang User" defang
exit 0

%post
%post_service %{name}
if [ ! -f %{_sysconfdir}/mail/mimedefang-ip-key ]; then
  %{_bindir}/gen-ip-validator.pl > %{_sysconfdir}/mail/mimedefang-ip-key
fi

%preun
%preun_service %{name}

%files
%doc --no-dereference LICENSE
%doc README.md README.NONROOT
%doc README.md README.SECURITY
%doc README.md README.SOPHIE
%doc README.md README.SPAMASSASSIN
%doc README.md README.FEDORA
%doc Changelog contrib/word-to-html examples/*filter*
%doc Changelog contrib/linuxorg examples/*filter*
%doc Changelog contrib/fang.pl examples/*filter*
%dir %attr(0750,defang,defang) %{_localstatedir}/log/%{name}
%dir %attr(0750,defang,defang) %{_localstatedir}/spool/MIMEDefang
%dir %attr(0750,defang,defang) %{_localstatedir}/spool/MD-Quarantine
%{_bindir}/*
%{_mandir}/man?/*
%{_unitdir}/%{name}.service
%{_unitdir}/%{name}-multiplexor.service
%{_libexecdir}/%{name}-wrapper
%{_tmpfilesdir}/%{name}.conf
%config(noreplace) %{_sysconfdir}/mail/mimedefang-filter
%config(noreplace) %{_sysconfdir}/mail/sa-mimedefang.cf
%ghost %config(noreplace) %{_sysconfdir}/mail/mimedefang-ip-key
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}

%changelog
