# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           minilens
Version:        1.2
Release:        alt1_5
Summary:        Libre puzzle platformer for gravity-oblivious aliens
Group:          Games/Puzzles
License:        GPLv3+ and CC BY-SA 4.0
URL:            https://kobuge-games.github.io/minilens
Source0:        https://github.com/KOBUGE-Games/minilens/archive/v%{version}/%{name}-%{version}.tar.gz
# Upstream bugfixes from https://github.com/KOBUGE-Games/minilens
Patch0:         0001-Replace-SUTjoystick-with-built-in-gamepad-support.patch
Patch1:         0002-Fix-the-way-screen-resizing-works-closes-79-maybe-80.patch
Patch2:         0003-Fix-issue-with-saves-locking-levels-refactor-breakab.patch
Patch3:         0004-Add-proper-attributions.patch

BuildArch:      noarch
Requires:       godot-runner
Source44: import.info

%description
A thousand years into post-apocalyptic Earth, many forms of life have
gone extinct, including humans. An alien robot series, called Minilens,
is cleaning up the Earth and collecting the surviving flora for research
purposes. The robots' duty is to destroy all radioactive barrels and to
collect all flora. Aliens forgot that Earth has gravity, therefore
Minilens can't jump.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build

%install
install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a . %{buildroot}%{_gamesdatadir}/%{name}/

cat << EOF > %{name}.sh
#!/bin/sh
exec godot-runner -path %{_gamesdatadir}/%{name} "\$@"
EOF
install -D -m755 %{name}.sh %{buildroot}%{_gamesbindir}/%{name}

install -D -m644 icon.png %{buildroot}%{_iconsdir}/hicolor/64x64/apps/%{name}.png

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Minilens
GenericName=Puzzle platformer
Comment=%{summary}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;LogicGame;
EOF

%files
%doc CREDITS.txt README.md
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/64x64/apps/%{name}.png


%changelog
