# BEGIN SourceDeps(oneline):
BuildRequires: libcrypt-devel libpam-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define name2     diffie

%define major     1
%define libname2  lib%{name2}%{major}
%define develname lib%{name2}-devel

%add_optflags -fcommon

Name: mirrordir
Summary: Easy to use ftp mirroring package
Version: 0.10.49
Release: alt1_34
Group: Networking/File transfer
License: GPLv2+
URL: ftp://ftp.obsidian.co.za/pub/mirrordir/
Source: ftp://ftp.obsidian.co.za/pub/mirrordir/mirrordir-%{version}.tar.bz2
Patch0: mirrordir-0.10.49-confpath.patch
Patch1: mirrordir-zlib-1.1.3-zfree.patch
Patch2: mirrordir-0.10.49-varargs.patch
Patch3: mirrordir-0.10.49-64bit-fixes.patch
Patch4: mirrordir-0.10.49-pam_pwdb.patch
# (tv) use system zlib:
Patch5: mirrordir-use-system-libs.patch
Patch6: mirrordir-0.10.49-fix-str-fmt.patch
Patch7: mirrordir-0.10.49-fix-install.patch
Patch8: mirrordir-0.10.49-automake-1.13.patch
Patch9: mirrordir-0.10.49-mga-noinline.patch
Patch10: mirrordir-0.10.49-mga-excl.patch
Patch11: mirrordir-0.10.49-mga-fix-buffer-overflow.patch
Patch12: mirrordir-0.10.49-gcc14.patch

BuildRequires: automake
BuildRequires: autoconf
BuildRequires: pkgconfig(zlib)

Requires: %{libname2} = %{version}
Source44: import.info

%description
Easy to use ftp mirroring package - simply use
mirrordir ftp://some.where.com/dir /some/local/dir

%package -n %{libname2}
Summary: The diffie library, necessary to run mirrordir
Group: System/Libraries

%description -n %{libname2}
The diffie library, necessary to run mirrordir.

%package -n %{develname}
Summary: Static version of the diffie library
Group: Development/C
Requires: %{libname2} = %{version}
Provides: lib%{name2}-devel = %{version}
Provides: %{name}-devel = %{version}

%description -n %{develname}
Static version of the diffie library.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1


%build
autoreconf -sfi
%configure \
	--disable-static \
	--enable-zlib \
	CFLAGS="%{optflags} -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE -std=gnu17"
%make_build

%install
%makeinstall_std

# we don't want these
find %{buildroot} -name '*.la' -delete

%files
%doc AUTHORS BUGS README NEWS THANKS TODO
%doc --no-dereference COPYING
%{_bindir}/*
%dir %{_sysconfdir}/mirrordir
%config(noreplace) %{_sysconfdir}/mirrordir/*
%config(noreplace) %{_sysconfdir}/secure*
%config(noreplace) %{_sysconfdir}/pam.d/*
%{_mandir}/man*/*

%files -n %{libname2}
%doc AUTHORS BUGS README NEWS THANKS TODO
%doc --no-dereference COPYING
%{_libdir}/lib%{name2}.so.%{major}
%{_libdir}/lib%{name2}.so.%{major}.*

%files -n %{develname}
%doc AUTHORS BUGS README NEWS THANKS TODO
%doc --no-dereference COPYING
%{_libdir}/lib%{name2}.so


%changelog
