Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(CGI/FastTemplate.pm) perl(HTML/Entities.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

%add_optflags -fcommon

Name:           mlmmj
Version:        1.3.0
Release:        alt2_16
Summary:        A simple and slim mailing list manager inspired by ezmlm
License:        MIT
URL:            http://mlmmj.org/
Source0:        http://mlmmj.org/releases/%{name}-%{version}.tar.bz2

BuildRequires:  gcc
BuildRequires:  findutils
Source44: import.info
%filter_from_requires /perl(.*[.]pl\\)\|\.bin\.bash/d

%description
Mlmmj(Mailing List Management Made Joyful) is a simple and slim mailing list 
manager (MLM) inspired by ezmlm. It works with many different Mail Transport 
Agents (MTAs) and is simple for a system adminstrator to install, configure 
and integrate with other software. As it uses very few resources, and requires
no daemons, it is ideal for installation on systems where resources are 
limited, such as Virtual Private Servers (VPSes).

Although it doesn't aim to include every feature possible, but focuses on 
staying mean and lean, and doing what it does do well, it does have a great 
set of features, including:

- Archive
- Custom headers / footer
- Fully automated bounce handling (similar to ezmlm)
- Complete requeueing functionality
- Moderation functionality
- Subject prefix
- Subscribers only posting
- Regular expression access control
- Functionality to retrieve old posts
- Web interface
- Digests
- No-mail subscription
- VERP support
- Delivery Status Notification (RFC1891) support
- Rich, customisable texts for automated operations

%prep
%setup -q

%build
%configure --enable-receive-strip
%make_build

%install
%makeinstall_std

mkdir -p %{buildroot}%{_localstatedir}/spool/%{name}
find contrib/ -type f -name *.pl -exec chmod -x {} ";"
find contrib/ -type f -name *.cgi -exec chmod -x {} ";"

%files
%{!?_licensedir:%global license %doc}
%doc --no-dereference COPYING
%doc AUTHORS ChangeLog FAQ README* TODO TUNABLES UPGRADE
%doc contrib/web/
%{_bindir}/*
%{_mandir}/man1/mlmmj*.1*
%{_datadir}/%{name}/
%{_localstatedir}/spool/%{name}

%changelog
