# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           moleinvasion
Version:        0.4
Release:        alt1_13
Summary:        Jump'n run game with Tux
License:        GPLv2+
Group:          Games/Arcade
URL:            https://moleinvasion.tuxfamily.org/
Source0:        https://download.tuxfamily.org/minvasion/packages/MoleInvasion-%{version}.tar.bz2
Patch0:         moleinvasions-fix-build.diff
Patch1:         moleinvasion-0.4-opengl.patch
Patch2:         moleinvasion-0.4-fno-common.patch
Patch3:         moleinvasion-0.4-gcc14.patch
BuildRequires:  SDL_mixer
BuildRequires:  libglvnd-devel
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(tcl)
BuildRequires:  pkgconfig(SDL_image)
BuildRequires:  pkgconfig(SDL_mixer)
BuildRequires:  pkgconfig(SDL_ttf)
BuildRequires:  pkgconfig(sdl)
Source44: import.info

%description
This is a classic jump and run game where Tux must deal with Moles.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build
export CFLAGS="${CFLAGS:-%optflags}";
export CXXFLAGS="${CXXFLAGS:-%optflags}";

make -C src

%install
%make_install DESTDIR=%buildroot install install-data -C src

# man pages
mkdir -p %{buildroot}%{_mandir}/man6/
cp debian/*.6 %{buildroot}%{_mandir}/man6/

# desktop file
mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{_vendor}-%{name}.desktop << EOF
[Desktop Entry]
Type=Application
Name=Mole Invasion
Icon=%{_gamesdatadir}/%{name}/gfx/icon.xpm
Exec=%{_gamesbindir}/%{name}
Terminal=false
Categories=Game;ActionGame;
EOF

%files
%{_gamesbindir}/*
%{_mandir}/man6/*
%{_gamesdatadir}/%{name}/
%{_datadir}/applications/%{_vendor}-%{name}.desktop


%changelog
