Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           mopac7
Summary:        Semi-empirical quantum mechanics suite
Version:        1.15
Release:        alt1_35
License:        Public Domain
URL:            http://sourceforge.net/projects/mopac7/
Source0:        http://bioinformatics.org/ghemical/download/current/mopac7-%{version}.tar.gz
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  gcc-fortran
BuildRequires:  libtool
Requires:       %{name}-libs = %{version}-%{release}
Source44: import.info

%description
MOPAC7 is a semi-empirical quantum-mechanics code written by James
J. P. Stewart and co-workers. The purpose of this project is to
maintain MOPAC7 as a stand-alone program as well as a library that
provides the functionality of MOPAC7 to other programs.

%package        libs
Group: Development/C
Summary:        Dynamic libraries from %{name}

%description    libs
Dynamic libraries from %{name}.

%package        devel
Group: Development/C
Summary:        Development files for %{name}
Requires:       %{name}-libs = %{version}-%{release}

%description    devel
This package contains libraries and header files for
developing applications that use %{name}.

%prep
%setup -q
perl -pi -e "s#-lg2c##g" libmopac7.pc.in

%build
autoreconf -fiv
%configure --disable-static
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%make_build

%install
%makeinstall_std
# make install does not actually install the main binary
# chrpath --delete     fortran/.libs/%{name}
install -pDm0755 fortran/.libs/%{name} %{buildroot}%{_bindir}/%{name}
# install a convenience fortran wrapper for the main binary
sed "s;./fortran;%{_bindir};" run_mopac7 > %{buildroot}%{_bindir}/run_mopac7
chmod 755 %{buildroot}%{_bindir}/run_mopac7
# kill off the .la files
find %{buildroot}%{_libdir} -name *.la -delete -print
# kill off the makefiles in tests directory so we can use them as samples in %doc
find tests -name 'Makefile*' -delete -print



%files
%doc tests
%{_bindir}/mopac7
%{_bindir}/run_mopac7

%files libs
%doc --no-dereference COPYING
%{_libdir}/libmopac7.so.*

%files devel
%doc AUTHORS ChangeLog NEWS README
%{_includedir}/mopac7/
%{_libdir}/libmopac7.so
%{_libdir}/pkgconfig/libmopac7.pc

%changelog
