Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: libchromaprint-devel libsox-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: FUSE filesystem to transcode FLAC to MP3 on the fly
Name: mp3fs
Version: 1.1.1
Release: alt2_15
# Automatically converted from old format: GPLv3+ and GFDL - review is highly recommended.
License: GPL-3.0-or-later AND LicenseRef-Callaway-GFDL
Source0: https://github.com/khenriks/mp3fs/releases/download/v%{version}/mp3fs-%{version}.tar.gz
URL: https://khenriks.github.io/mp3fs/
# While mp3fs does encode to MP3, it is a consumer, not a provider
#Provides: mp3encoder
# While mp3fs does not strictly require the fuse cli (which does not provide
# the fuse libraries), mp3fs is fairly useless without it.
Requires: fuse
BuildRequires: libfuse-devel liblame-devel libflac++-devel libflac-devel libid3tag-devel gcc-c++
BuildRequires: libvorbis-devel
BuildRequires: zlib-devel
Source44: import.info

%description
MP3FS is A read-only FUSE file-system which trans-codes audio formats (currently
FLAC/OGG) to MP3 on the fly when opened and read. This was written to enable me
to use my FLAC collection with software and/or hardware which only understands
MP3. e.g. "GMediaServer" to a Netgear MP101 mp3 player.

It is also a novel alternative to traditional mp3 encoder applications. Just
use your favorite file browser to select the files you want encoded and copy
them somewhere!

%prep
%setup -q 

%build
%configure
%{make_build} LDFLAGS="$RPM_LD_FLAGS -lm" V=1

%install
%makeinstall_std

%files
%{!?_licensedir:%global license %%doc}
%doc --no-dereference COPYING COPYING.DOC
%doc README.md INSTALL.md NEWS.md
%{_bindir}/%{name}
%{_mandir}/man1/*

%changelog
