# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           mrrescue
Version:        1.02e
Release:        alt1_6
Summary:        Action game where you evacuate civilians from burning buildings
Group:          Games/Arcade
License:        zlib and CC-BY-SA 3.0
URL:            https://tangramgames.dk/games/mrrescue/
Source0:        https://github.com/SimonLarsen/mrrescue/archive/%{version}/%{name}-%{version}.tar.gz
Source1:        mrrescue.png
Patch0:         mrrescue-1.02e-git-love.patch

BuildArch:      noarch
BuildRequires:  zip
Requires:       love >= 0.10
Source44: import.info

%description
Mr. Rescue is an arcade styled 2d action game centered around
evacuating civilians from burning buildings.

The game features fast paced fire extinguishing action,
intense boss battles, a catchy soundtrack and lots of throwing people
around in pseudo-randomly generated buildings.

%files
%doc LICENSE README.md
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/%{name}.love
%{_iconsdir}/hicolor/*/apps/%{name}.png

#----------------------------------------------------------------------------

%prep
%setup -q
%patch0 -p1


%build
# Create .love archive
zip -9 -q -r %{name}.love .

# Launcher script
cat > %{name}.sh << EOF
#!/bin/sh
love %{_gamesdatadir}/%{name}/%{name}.love
EOF

# Desktop entry
cat > %{name}.desktop << EOF
[Desktop Entry]
Name=Mr. Rescue
Comment=Evacuate civilians from burning buildings
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF

%install
install -D -m 644 %{name}.love %{buildroot}%{_gamesdatadir}/%{name}/%{name}.love
install -D -m 755 %{name}.sh %{buildroot}%{_gamesbindir}/%{name}
install -D -m 644 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop
install -D -m 644 %{_sourcedir}/%{name}.png %{buildroot}%{_iconsdir}/hicolor/256x256/apps/%{name}.png


%changelog
