%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: msgpuck
Version: 2.0.36
Release: alt2_5
Summary: MsgPack binary serialization library in a self-contained header
License: BSD
URL: https://github.com/tarantool/msgpuck
Source0: https://github.com/rtsisyk/msgpuck/archive/%{version}/msgpuck-%{version}.tar.gz
BuildRequires:  gcc-c++
BuildRequires: gcc
BuildRequires: coreutils
BuildRequires: ctest cmake
BuildRequires: doxygen >= 1.6.0

# https://fedoraproject.org/wiki/Packaging:Guidelines#Packaging_Header_Only_Libraries
# Nothing to add to -debuginfo package - this library is header-only
%global debug_package %{nil}
Source44: import.info

%package devel
Group: Other
Summary: MsgPack serialization library in a self-contained header file
Provides: msgpuck-static = %{version}-%{release}

%description
MsgPack is a binary-based efficient object serialization library.
It enables to exchange structured objects between many languages like JSON.
But unlike JSON, it is very fast and small.

msgpuck is very lightweight header-only library designed to be embedded to
your application by the C/C++ compiler. The library is fully documented and
covered by unit tests.

%description devel
MsgPack is a binary-based efficient object serialization library.
It enables to exchange structured objects between many languages like JSON.
But unlike JSON, it is very fast and small.

msgpuck is very lightweight header-only library designed to be embedded to
your application by the C/C++ compiler. The library is fully documented and
covered by unit tests.

This package provides a self-contained header file and a static library.
The static library contains generated code for inline functions and
global tables needed by the some library functions.

%prep
%setup -q -n %{name}-%{version}

%build
%{fedora_v2_cmake} . -DCMAKE_BUILD_TYPE=RelWithDebInfo
%fedora_v2_cmake_build
%fedora_v2_cmake_build --target man

%check
%fedora_v2_ctest
make -C %{__cmake_builddir} test

%install
%fedora_v2_cmake_install
mkdir -p %{buildroot}%{_mandir}/man3
install -Dpm 0644 %{__cmake_builddir}/doc/man/man3/msgpuck.h.3* %{buildroot}%{_mandir}/man3/

%files devel
%{_libdir}/libmsgpuck.a
%{_includedir}/msgpuck.h
%{_mandir}/man3/msgpuck.h.3*
%doc README.md
%{!?_licensedir:%global license %doc}
%doc --no-dereference LICENSE AUTHORS

%changelog
