# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define oname muCommander

Name:       mucommander
Version:    0.9.2
Release:    alt1_6
Summary:    muCommander is a lightweight, cross-platform file manager
License:    GPLv3, LGPLv3, ASL 2.0, BSD, CC-BY, ICU
Group:      File tools
URL:        https://www.mucommander.com/
Source0:    https://github.com/mucommander/mucommander/releases/download/%{version}/%{name}-%{version}.tar.gz
Source1:    %{name}.png
Source2:    %{name}
Source3:    %{name}.desktop
BuildArch:  noarch
BuildRequires: java >= 1.6.0
Requires:   java >= 1.6.0
Source44: import.info

%description
muCommander is a lightweight, cross-platform file manager with a dual-pane
interface. It runs on any operating system with Java support
(Mac OS X, Windows, Linux, *BSD, Solaris...).
 
Here's a non-exhaustive list of what you'll find:

* Virtual filesystem with support for local volumes,
    FTP, SFTP, SMB, NFS, HTTP, Amazon S3, Hadoop HDFS and Bonjour
* Quickly copy, move, rename files, create directories, email files...
* Browse, create and uncompress ZIP, RAR, 7z, TAR, GZip, BZip2, ISO/NRG,
    AR/Deb and LST archives
* ZIP files can be modified on-the-fly, without having to recompress the 
    whole archive
* Universal bookmarks and credentials manager
* Multiple windows support
* Full keyboard access
* Highly configurable
* Available in 23 languages : American & British English, French, German,
    Spanish, Czech, Simplified & Traditional Chinese, Polish, Hungarian,
    Russian, Slovenian, Romanian, Italian, Korean, Brazilian Portuguese,
    Dutch, Slovak, Japanese, Swedish, Danish, Ukrainian and Arabic.
* Free Software (GPL)

%prep 
%setup -q -n %{oname}-%{version}

%build
# nothing

%install
install -dm 755 %{buildroot}%{_javadir}
install -dm 755 %{buildroot}%{_javadir}/%{name}
cp -f *.jar %{buildroot}%{_javadir}/%{name}/
cp -f *.sh %{buildroot}%{_javadir}/%{name}/
mkdir -p %{buildroot}/%{_datadir}/pixmaps
install -m 644 %{SOURCE1} %{buildroot}/%{_datadir}/pixmaps
mkdir -p %{buildroot}%{_bindir}
install -m 755 %{SOURCE2} %{buildroot}%{_bindir}/%{name}
mkdir -p %{buildroot}%{_datadir}/applications
install -m 644 %{SOURCE3} %{buildroot}%{_datadir}/applications/

%files
%doc license.txt readme.txt
%{_javadir}/*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png
%{_bindir}/%{name}


%changelog
