# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/gconftool-2 /usr/bin/glib-gettextize /usr/bin/pkg-config pkgconfig(glib-2.0)
# END SourceDeps(oneline)
# This can be safely commented out at next point release,
# changes should only use %gitver when it's defined. Sorry
# for the mess.
%global gitver 32a1da0160

Name:           nautilus-open-terminal
Version:        0.20
Release:        alt1_5
Summary:        Nautilus extension for an open terminal shortcut

Group:          Graphical desktop/GNOME
License:        GPLv2+
URL:            http://download.gnome.org/sources/%{name}/
Source0:        http://download.gnome.org/sources/%{name}/%{version}/%{name}-%{version}.tar.xz

BuildRequires:	intltool
# need extensions
BuildRequires:	libnautilus-devel

# https://bugzilla.redhat.com/show_bug.cgi?id=653289
# Icon missing from Open in Terminal menu entry
Patch0:         nautilus-open-terminal-0.19-restoreicon.patch
BuildRequires:  autoconf automake libtool libGConf-devel

Requires(pre): GConf2
Requires(post): GConf2
Requires(preun): GConf2
Source44: import.info

%description
The nautilus-open-terminal extension provides a right-click "Open
Terminal" option for nautilus users who prefer that option.

%prep
%setup -q
%patch0 -p1 -b .restoreicon

%build
%configure
make %{?_smp_mflags}


%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT/%{_libdir}/nautilus/extensions-3.0/*.{l,}a

%find_lang %{name}


%pre
if [ "$1" -gt 1 ]; then
  export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
  gconftool-2 --makefile-uninstall-rule \
              %{_sysconfdir}/gconf/schemas/%{name}.schemas > /dev/null || :
fi

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 \
	    --makefile-install-rule \
	    %{_sysconfdir}/gconf/schemas/%{name}.schemas >/dev/null || :

%preun
if [ "$1" -eq 0 ]; then
  export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
  gconftool-2 --makefile-uninstall-rule \
              %{_sysconfdir}/gconf/schemas/%{name}.schemas > /dev/null || :
fi


%files -f %{name}.lang
%doc AUTHORS ChangeLog COPYING NEWS TODO
%config(noreplace) %{_sysconfdir}/gconf/schemas/*
%{_libdir}/nautilus/extensions-3.0/*.so*

%changelog
