Group: Development/Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nbc
Version:        1.2.1.r3
Release:        alt2_33
Summary:        Simple language and compiler to program the LEGO NXT brick
URL:            http://bricxcc.sourceforge.net/nbc/
# Automatically converted from old format: MPLv1.1 - review is highly recommended.
License:        LicenseRef-Callaway-MPLv1.1
Source0:        http://downloads.sourceforge.net/bricxcc/%{name}-%{version}.src.tgz

# This patch fixes the installation paths for the binary and manpage, 
# and adds a -g to the Pascal buildflags so a debuginfo package
# can be generated.  Not yet submitted upstream
Patch0:         %{name}-1.2.1.r3.fixinstall.patch

# Match fpc architectures
BuildRequires:  glibc-devel glibc-devel-static
BuildRequires:  fpc-compiler fpc-units-gfx fpc-units-misc fpc-utils
BuildRequires:  libusb-compat-devel
BuildRequires:  dos2unix
Source44: import.info

%description
Next Byte Codes (NBC) is a simple language with an assembly language
syntax that can be used to program LEGO's NXT programmable brick
(from the new LEGO Mindstorms NXT set).

Not Exactly C (NXC) is a high level language, similar to C, built on
top of the NBC compiler. It can also be used to program the NXT brick.
NXC is basically NQC (Not Quite C) for the NXT.

%prep
%setup -c -q
%patch0  -p0 -b .fixinstall

cd doc
for f in Readme Changelog; do
  dos2unix -n $f $f.tmp && \
  touch -r $f $f.tmp && \
  mv $f.tmp $f
done

%build
make

%install
make install DISTDIR=%{buildroot}

%files
%doc doc/Changelog doc/Readme
%{_bindir}/nbc
%{_mandir}/man1/nbc.1*

%changelog
