Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Daemon that responds to network cables being plugged in and out
Name: netplug
Version: 1.2.9.2
Release: alt1_30
# Automatically converted from old format: GPLv2 - review is highly recommended.
License: GPL-2.0-only
URL: http://www.red-bean.com/~bos/
Source0: http://www.red-bean.com/~bos/netplug/netplug-%{version}.tar.bz2
Source1: netplugd.service

#execshield patch for netplug <t8m@redhat.com>
Patch1: netplug-1.2.9.2-execshield.patch

Patch2: netplug-1.2.9.2-man.patch

BuildRequires:  gcc
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
BuildRequires: gettext-tools

Requires: iproute2
Source44: import.info

%description
Netplug is a daemon that manages network interfaces in response to
link-level events such as cables being plugged in and out.  When a
cable is plugged into an interface, the netplug daemon brings that
interface up.  When the cable is unplugged, the daemon brings that
interface back down.

This is extremely useful for systems such as laptops, which are
constantly being unplugged from one network and plugged into another,
and for moving systems in a machine room from one switch to another
without a need for manual intervention.

%prep
%setup -q
%patch1  -p1 -b .execshield
%patch2  -p1 -b .man

%build
export CFLAGS="$RPM_OPT_FLAGS $CFLAGS"
make

%install
make install prefix=%{buildroot} \
             bindir=%{buildroot}/%{_sbindir} \
             mandir=%{buildroot}/%{_mandir}

mkdir -p %{buildroot}/%{_mandir}/man5
ln -fs %{_mandir}/man8/netplugd.8.gz %{buildroot}/%{_mandir}/man5/netplug.5.gz
ln -fs %{_mandir}/man8/netplugd.8.gz %{buildroot}/%{_mandir}/man5/netplug.d.5.gz
ln -fs %{_mandir}/man8/netplugd.8.gz %{buildroot}/%{_mandir}/man5/netplugd.conf.5.gz

# systemd unit files
mkdir -p %{buildroot}%{_unitdir}
install -m 644 %{SOURCE1} %{buildroot}%{_unitdir}

rm -f %{buildroot}/etc/rc.d/init.d/netplugd
sed -i s,/sbin/netplugd,/usr/sbin/netplugd, %{buildroot}%{_unitdir}/*

%post
%post_service netplugd

%preun
%preun_service netplugd
 
%files
%doc COPYING README TODO
%{_sbindir}/netplugd
%{_mandir}/man[58]/*
%dir %{_sysconfdir}/netplug.d
%{_sysconfdir}/netplug.d/netplug
%config(noreplace) %{_sysconfdir}/netplug.d/netplugd.conf
%{_unitdir}/netplugd.service

%changelog
