Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		netsniff-ng
Version:	0.6.8
Release:	alt2_16
Summary:	Packet sniffing beast
License:	GPLv2
URL:		http://netsniff-ng.org/
Source0:	http://www.netsniff-ng.org/pub/netsniff-ng/netsniff-ng-%{version}.tar.xz
BuildRequires:	gcc
BuildRequires:	libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
# GeoIP not in RHEL-9+
%if 0%{?rhel} < 9
BuildRequires:	libGeoIP-devel
%endif
BuildRequires:	libnetfilter_conntrack-devel
BuildRequires:	libuserspace-rcu-devel
BuildRequires:	libnl-devel
BuildRequires:	flex
BuildRequires:	bison
BuildRequires:	libcli-devel
BuildRequires:	perl-podlators
BuildRequires:	zlib-devel
BuildRequires:	libpcap-devel
BuildRequires:	libnet2-devel
BuildRequires:	libsodium-devel
Source44: import.info

%description
netsniff-ng is a high performance Linux network sniffer for packet inspection.
It can be used for protocol analysis, reverse engineering or network
debugging. The gain of performance is reached by 'zero-copy' mechanisms, so
that the kernel does not need to copy packets from kernelspace to userspace.

netsniff-ng toolkit currently consists of the following utilities:

* netsniff-ng: the zero-copy sniffer, pcap capturer and replayer itself.
* trafgen: a high performance zero-copy network packet generator.
* ifpps: a top-like kernel networking and system statistics tool.
* curvetun: a lightweight curve25519-based multiuser IP tunnel.
* ashunt: an autonomous system trace route and ISP testing utility.
* flowtop: a top-like netfilter connection tracking tool.
* bpfc: a tiny Berkeley Packet Filter compiler supporting Linux extensions.

%prep
%setup -q


%build
export NACL_INC_DIR=$(pkg-config --variable=includedir libsodium )/sodium
export NACL_LIB=sodium
# the current configure script doesn't support unknown options, thus we cannot
# use the generic %%configure macro
./configure --prefix='%{_prefix}' --sysconfdir='%{_sysconfdir}'
# the -fcommon is workaround to build with gcc-10, problem reported upstream
%make_build ETCDIR=%{_sysconfdir} Q= STRIP=: \
  CFLAGS="%{optflags} -fPIC -fcommon" LDFLAGS="%{?__global_ldflags}"

%install
make install PREFIX=%{_prefix} ETCDIR=%{_sysconfdir} DESTDIR="%{buildroot}"

%files
%doc AUTHORS COPYING README
%{_sbindir}/*
%dir %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/*
%{_mandir}/man8/*

%changelog
