Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/inews /usr/bin/rnews
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# https://src.fedoraproject.org/rpms/redhat-rpm-config/blob/master/f/buildflags.md#legacy-fcommon
%add_optflags -fcommon

Name:		newsx
Version:	1.6
Release:	alt4_40
License:	GPLv2+
Summary:	NNTP news exchange utility
Summary(pl):	Narzędzie do wymiany newsów po NNTP
Source0:	ftp://ftp.tin.org/pub/news/utils/newsx/%{name}-%{version}.tar.gz
# Source0-md5:	ad9c76c53d5c7d21d86bec805fe8cd34
Patch0:		%{name}-make.patch
Patch1:		%{name}-stack.patch
Patch2:		%{name}-quotes.patch
# port to automake 1.12+
Patch3:		%{name}-automake.patch
BuildRequires:  gcc
BuildRequires:	libinn-devel
BuildRequires:	automake
BuildRequires:	autoconf
# work around https://bugzilla.redhat.com/show_bug.cgi?id=927170
BuildRequires:	perl-base
Requires:	inn
Source44: import.info

%description
Newsx is an NNTP client that will connect to a remote NNTP server and
post outgoing news articles batched by the news system (e.g. INN), as
well as fetch incoming articles.

%description -l pl
Newsx jest klientem NNTP który łączy się ze zdalnym serwerem i wysyła
wychodzące artykuły zgromadzone przez system newsów (np. INN) oraz
pobiera przychodzące artykuły.

%prep
%setup -q
%patch0 -p1
%patch1 -p1 -b .stack
%patch2 -p1 -b .quotes
%patch3 -p1 -b .am-1.12

%build
autoreconf -f -i
%configure \
	--with-inhosts=/var/spool/news/inhosts \
	--with-newsconfig=/usr/lib/news/lib/innshellvars \
	--with-newslib=%{_libdir}/news/lib \

make %{?_smp_mflags}

%install

make install \
	DESTDIR=$RPM_BUILD_ROOT

# avoid conflict with leafnode
pushd $RPM_BUILD_ROOT
mv .%{_bindir}/newsq .%{_bindir}/newsx-newsq
mv .%{_mandir}/man1/newsq.1 .%{_mandir}/man1/newsx-newsq.1
popd

%files
%doc AUTHORS ChangeLog COPYING FAQ NEWS README TODO
%attr(755,root,root) %{_bindir}/*
%attr(770,root,news) %dir /var/spool/news/inhosts
%{_mandir}/man[158]/*

%changelog
