# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nfrotz
Summary:        Z-machine interpreter for Interactive Fiction games, with support for unicode
Version:        0.3.3
Release:        alt1_14
Source0:        https://mirror.ifarchive.org/if-archive/infocom/interpreters/frotz/%{name}-%{version}.tgz
Patch0:         nfrotz-fix-building-with-gcc14.patch
URL:            https://www.stanford.edu/~mcmartin/if/
License:        GPLv2

Group:          Games/Adventure
BuildRequires:  pkgconfig(ncursesw)
Source44: import.info

%description
NFrotz is a Z-Machine interpreter. The Z-machine is a virtual machine
designed by Infocom to run all of their text adventures. It went
through multiple revisions during the lifetime of the company, and two
further revisions (V7 and V8) were created by Graham Nelson after the
company's demise. The specification is now quite well documented; this
version of Frotz supports version 1.1.

This version of Frotz fully supports all these versions of the Z-Machine
except for version 6. Version 6 is semi-supported by displaying the
outlines of V6 graphics with the picture number in the bottom-right corner.

NFrotz is a merged port of the original Unix Frotz, incorporating
extensions made by the WinFrotz port.
The primary visible difference between NFrotz and ordinary Frotz is
support for UTF-8 terminals and some awareness of iFiction-based metadata
if present.

%prep
%setup -q
%patch0 -p1


perl -pi -e "s|/lib/|/%_lib/|" configure

# do not strip binary:
sed -i -e 's|strip nfrotz||' Makefile

%build
export CFLAGS="%{optflags} -std=gnu17"
%configure
%make_build

%install
%makeinstall_std PREFIX=%{buildroot}%{_prefix} MAN_PREFIX=%{buildroot}%{_datadir}

%files
%doc AUTHORS ChangeLog COPYING HOW_TO_PLAY README
%{_mandir}/*/*
%{_bindir}/*


%changelog
