Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: libX11-devel libXinerama-devel pkgconfig(glib-2.0) pkgconfig(gthread-2.0) pkgconfig(gtk+-2.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nitrogen
Version:        1.6.1
Release:        alt2_17
Summary:        Background browser and setter for X windows

# Code is GPLv2+ and zlib, icons are CC-BY-SA as described in COPYING
License:        GPLv2+ and zlib and CC-BY-SA
URL:            https://github.com/l3ib/%{name}/
Source:         https://github.com/l3ib/%{name}/releases/download/%{version}/%{name}-%{version}.tar.gz
Patch0:         appdata.patch
BuildRequires:  libgtkmm2-devel
BuildRequires:  libpng-devel libpng17-tools
BuildRequires:  gettext-tools
BuildRequires:  desktop-file-utils
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  m4
BuildRequires:  libtool
BuildRequires:  gettext-tools libasprintf-devel
BuildRequires:  gcc-c++
Requires:       libgtkmm2
Source44: import.info

%description
A background browser and setter for X windows that can be used in two
modes: browser and recall. It features Multihead and Xinerama awareness,
a recall mode to be used in start up scripts, uses the freedesktop.org
standard for thumbnails, can set the GNOME background, command line set
modes for use in scripts, inotify monitoring of browse directory, lazy
loading of thumbnails to conserve memory and an 'automatic' set mode
which determines the best mode to set an image based on its size.

%prep
%setup -q

%patch0

%build
autoreconf -fi

%configure --disable-dependency-tracking
# -lX11 is missing (DSO: https://fedoraproject.org/wiki/UnderstandingDSOLinkChange)
%make_build CFLAGS="%{optflags}" LDFLAGS="-lX11"

%install
make install DESTDIR=%{buildroot}
%find_lang %{name}

%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/%{name}.appdata.xml

%files -f %{name}.lang
%doc COPYING NEWS README AUTHORS ChangeLog
%{_bindir}/%{name}
%{_metainfodir}/%{name}.appdata.xml
%{_datadir}/icons/hicolor/16x16/actions/wallpaper-*.png
%{_datadir}/icons/hicolor/16x16/devices/video-display.png
%{_datadir}/icons/hicolor/16x16/mimetypes/image-x-generic.png
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png
%{_mandir}/man1/%{name}.1*


%changelog
