Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with internet

Name:           nodejs-agentkeepalive
Version:        3.5.2
Release:        alt1_3
Summary:        Missing keep-alive http.Agent

License:        MIT
URL:            https://github.com/node-modules/agentkeepalive
Source0:        https://github.com/node-modules/agentkeepalive/archive/%{version}.tar.gz#/%{name}-%{version}.tar.gz
Source20:       nodejs-agentkeepalive-ssl.conf
# Remove tests that need internet access
Patch0:         nodejs-agentkeepalive-internet.patch
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  openssl
BuildRequires:  npm(mocha)
BuildRequires:  npm(humanize-ms)
BuildRequires:  npm(should)
BuildRequires:  npm(should-http)
BuildRequires:  npm(pedding)
Source44: import.info

%description
The nodejs's missing keep alive http.Agent. Support HTTP and HTTPS.


%prep
%setup -q -n agentkeepalive-%{version}
%if ! %{with internet}
%patch0 -p1
%endif
rm -rf node_modules


%build


%install
mkdir -p %{buildroot}/%{nodejs_sitelib}/agentkeepalive
cp -pr package.json index.js lib %{buildroot}/%{nodejs_sitelib}/agentkeepalive
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
pushd test/fixtures
OPENSSL_CONF=%{SOURCE20} sh genkey.sh
popd
%{nodejs_sitelib}/mocha/bin/mocha -R spec -t 10000 -r should-http test/*.test.js


%files
%doc README.md History.md AUTHORS example
%{nodejs_sitelib}/agentkeepalive


%changelog
