Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename any-path

%global enable_tests 0
# Tests disabled in order to bootstrap a newer version of npm(tap)

Name:		nodejs-any-path
Version:	1.3.0
Release:	alt1_5
Summary:	Make the keys on an object path.sep agnostic

License:	ISC
URL:		https://github.com/bcoe/any-path.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/bcoe/any-path/v%{version}/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	npm(chai)
BuildRequires:	npm(tap)
BuildRequires:	npm(tap-mocha-reporter)
%endif
Source44: import.info

%description
make the keys on an object path.sep agnostic.


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .



%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/tap --coverage test.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE.txt
%{nodejs_sitelib}/%{packagename}


%changelog
