Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


# babel-core not in Fedora
%global enable_tests 0

%global barename ast-types

%global commit0 c9d0ca55da8fadef0fefcce1dcdc0859e9e8bb94
%global shortcommit0 %(c=%{commit0}; echo ${c:0:7})

Name:               nodejs-ast-types
Version:            0.8.13
Release:            alt1_7
Summary:            Esprima-compatible implementation of the Mozilla JS Parser API

License:            MIT
URL:                https://www.npmjs.org/package/ast-types
Source0:            https://github.com/benjamn/%{barename}/archive/%{commit0}.tar.gz#/%{barename}-%{shortcommit0}.tar.gz
BuildArch:          noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:      npm(esprima)
BuildRequires:      npm(babel-core)
BuildRequires:      npm(esprima-fb)
BuildRequires:      npm(mocha)
%endif
Source44: import.info


%description
This module provides an efficient, modular, Esprima-compatible implementation
of the abstract syntax tree type hierarchy pioneered by the Mozilla Parser API.

%prep
%setup -qn %{barename}-%{commit0}

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/ast-types
cp -pr package.json main.js lib/ def/ \
    %{buildroot}%{nodejs_sitelib}/ast-types

%nodejs_symlink_deps


%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
mocha --reporter spec test/run.js
%endif


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/ast-types/

%changelog
