Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# native-promise-only and rsvp not packaged yet
%global enable_mocha_tests 1
%global enable_nodeunit_tests 0

Name:           nodejs-async
Version:        1.5.2
Release:        alt1_8
Summary:        Higher-order functions and common patterns for asynchronous code

License:        MIT
URL:            https://github.com/caolan/async/
Source0:        https://github.com/caolan/async/archive/v%{version}/async-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_mocha_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(chai)
%endif

%if 0%{?enable_nodeunit_tests}
BuildRequires:  npm(nodeunit)
BuildRequires:  npm(bluebird)
BuildRequires:  npm(es6-promise)
BuildRequires:  npm(native-promise-only)
BuildRequires:  npm(rsvp)
%endif
Source44: import.info

%description
Async is a utility module which provides straight-forward, powerful functions
for working with asynchronous JavaScript. Although originally designed for
use with Node.js, it can also be used directly in the browser.

Async provides around 20 functions that include the usual 'functional'
suspects (map, reduce, filter, forEacha..) as well as some common patterns
for asynchronous control flow (parallel, series, waterfalla..). All these
functions assume you follow the Node.js convention of providing a single
callback as the last argument of your async function.


%prep
%setup -q -n async-%{version}


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/async
cp -pr package.json lib %{buildroot}%{nodejs_sitelib}/async


%check
%nodejs_symlink_deps --check
%__nodejs -e "require('./')"
%if 0%{?enable_mocha_tests}
%{nodejs_sitelib}/mocha/bin/mocha mocha_test
%endif
%if 0%{?enable_nodeunit_tests}
%{nodejs_sitelib}/nodeunit/bin/nodeunit test/test-async.js
%endif


%files
%doc README.md CHANGELOG.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/async


%changelog
