Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 34
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global modname backbone

%if ! ( 0%{?fedora} || 0%{?rhel} >= 7 )

%global nodejs_arches %{ix86} x86_64 %{arm}
%endif

# tests are disabled for now (need QUnit, runs in PhantomJS?)
%bcond_with tests

Name:           nodejs-%{modname}
Version:        1.3.3
Release:        alt2_12
Summary:        Models, Views, Collections, and Events for JavaScript applications (Nodejs module)
License:        MIT
URL:            http://backbonejs.org/
Source0:        http://registry.npmjs.org/%{modname}/-/%{modname}-%{version}.tgz
# git archive --format=tar --prefix=test/ 1.3.3:test/ | bzip2 >tests-1.3.3.tar.bz2
Source1:        tests-%{version}.tar.bz2
BuildArch:      noarch
BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  web-assets-devel
BuildRequires:  node-uglify-js
Requires:       js-%{modname} = %{version}-%{release}
%if %{with tests}
BuildRequires:  node
BuildRequires:  nodejs-qunit
%endif
Source44: import.info

%description
Backbone supplies structure to JavaScript-heavy applications by providing 
models key-value binding and custom events, collections with a rich API of 
enumerable functions, views with declarative event handling, and connects it 
all to your existing application over a RESTful JSON interface.

This package provides Backbone as a Nodejs module, for use in server-side 
applications or with browserify.

%package -n js-%{modname}
Group: Development/Other
Summary:        Models, Views, Collections and Events for JavaScript applications
Requires:       web-assets-filesystem

%description -n js-%{modname}
Backbone supplies structure to JavaScript-heavy applications by providing 
models key-value binding and custom events, collections with a rich API of 
enumerable functions, views with declarative event handling, and connects it 
all to your existing application over a RESTful JSON interface.

%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
rm backbone-min.{js,map}

%build
uglifyjs backbone.js -m --source-map -o backbone-min.js

%if %{with tests}
%check
%nodejs_symlink_deps --check
# ?
%endif

%install
mkdir -p %{buildroot}%{_jsdir}/%{modname}
cp -p backbone.js backbone-min.js backbone-min.js.map %{buildroot}%{_jsdir}/%{modname}/
mkdir -p %{buildroot}%{nodejs_sitelib}/%{modname}
cp -p backbone.js package.json %{buildroot}%{nodejs_sitelib}/%{modname}/
%nodejs_symlink_deps

%files
%{nodejs_sitelib}/%{modname}

%files -n js-%{modname}
%doc README.md
%doc --no-dereference LICENSE
%{_jsdir}/%{modname}

%changelog
